/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.clients;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerThreadpool;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.component.UserBindingPattern;
import java.util.Collection;
import java.util.Collections;

public class ContainerDocumentApi {
    private static final int FALLBACK_MAX_POOL_SIZE = 0;
    private static final int FALLBACK_CORE_POOL_SIZE = 0;

    public ContainerDocumentApi(ContainerCluster<?> cluster, Options options) {
        ContainerDocumentApi.addRestApiHandler(cluster, options);
        ContainerDocumentApi.addFeedHandler(cluster, options);
    }

    private static void addFeedHandler(ContainerCluster<?> cluster, Options options) {
        String bindingSuffix = "/reserved-for-internal-use/feedapi";
        Handler<AbstractConfigProducer<?>> handler = ContainerDocumentApi.newVespaClientHandler("com.yahoo.vespa.http.server.FeedHandler", bindingSuffix, options);
        cluster.addComponent(handler);
        Threadpool executor = new Threadpool("feedapi-handler", cluster, options.feedApiThreadpoolOptions, options.feedThreadPoolSizeFactor);
        handler.inject(executor);
        handler.addComponent(executor);
    }

    private static void addRestApiHandler(ContainerCluster<?> cluster, Options options) {
        String oldHandlerName = "com.yahoo.document.restapi.resource.RestApi";
        String bindingSuffix = "/document/v1/*";
        Handler<AbstractConfigProducer<?>> oldHandler = ContainerDocumentApi.newVespaClientHandler(oldHandlerName, options.useNewRestapiHandler ? null : bindingSuffix, options);
        cluster.addComponent(oldHandler);
        Threadpool executor = new Threadpool("restapi-handler", cluster, options.restApiThreadpoolOptions, options.feedThreadPoolSizeFactor);
        oldHandler.inject(executor);
        oldHandler.addComponent(executor);
        if (options.useNewRestapiHandler) {
            String newHandlerName = "com.yahoo.document.restapi.resource.DocumentV1ApiHandler";
            Handler<AbstractConfigProducer<?>> newHandler = ContainerDocumentApi.newVespaClientHandler(newHandlerName, bindingSuffix, options);
            cluster.addComponent(newHandler);
        }
    }

    private static Handler<AbstractConfigProducer<?>> newVespaClientHandler(String componentId, String bindingSuffix, Options options) {
        Handler handler = new Handler(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)componentId, null, (String)"vespaclient-container-plugin"), ""));
        if (bindingSuffix == null) {
            return handler;
        }
        if (options.bindings.isEmpty()) {
            handler.addServerBindings(SystemBindingPattern.fromHttpPath(bindingSuffix), SystemBindingPattern.fromHttpPath(bindingSuffix + "/"));
        } else {
            for (String rootBinding : options.bindings) {
                String pathWithoutLeadingSlash = bindingSuffix.substring(1);
                handler.addServerBindings(UserBindingPattern.fromPattern(rootBinding + pathWithoutLeadingSlash), UserBindingPattern.fromPattern(rootBinding + pathWithoutLeadingSlash + "/"));
            }
        }
        return handler;
    }

    private static class Threadpool
    extends ContainerThreadpool {
        private final ContainerCluster<?> cluster;
        private final double feedThreadPoolSizeFactor;

        Threadpool(String name, ContainerCluster<?> cluster, ContainerThreadpool.UserOptions threadpoolOptions, double feedThreadPoolSizeFactor) {
            super(name, threadpoolOptions);
            this.cluster = cluster;
            this.feedThreadPoolSizeFactor = feedThreadPoolSizeFactor;
        }

        @Override
        public void getConfig(ContainerThreadpoolConfig.Builder builder) {
            super.getConfig(builder);
            if (this.hasUserOptions()) {
                return;
            }
            builder.maxThreads(this.maxPoolSize());
            builder.minThreads(this.minPoolSize());
            builder.queueSize(500);
        }

        private int maxPoolSize() {
            double vcpu = Threadpool.vcpu(this.cluster).orElse(0.0);
            if (vcpu == 0.0) {
                return 0;
            }
            return Math.max(2, (int)Math.ceil(vcpu * this.feedThreadPoolSizeFactor));
        }

        private int minPoolSize() {
            double vcpu = Threadpool.vcpu(this.cluster).orElse(0.0);
            if (vcpu == 0.0) {
                return 0;
            }
            return Math.max(1, (int)Math.ceil(vcpu * this.feedThreadPoolSizeFactor * 0.5));
        }
    }

    public static final class Options {
        private final Collection<String> bindings;
        private final ContainerThreadpool.UserOptions restApiThreadpoolOptions;
        private final ContainerThreadpool.UserOptions feedApiThreadpoolOptions;
        private final double feedThreadPoolSizeFactor;
        private final boolean useNewRestapiHandler;

        public Options(Collection<String> bindings, ContainerThreadpool.UserOptions restApiThreadpoolOptions, ContainerThreadpool.UserOptions feedApiThreadpoolOptions, double feedThreadPoolSizeFactor, boolean useNewRestapiHandler) {
            this.bindings = Collections.unmodifiableCollection(bindings);
            this.restApiThreadpoolOptions = restApiThreadpoolOptions;
            this.feedApiThreadpoolOptions = feedApiThreadpoolOptions;
            this.feedThreadPoolSizeFactor = feedThreadPoolSizeFactor;
            this.useNewRestapiHandler = useNewRestapiHandler;
        }
    }
}

