/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class IndexingInputs
extends Processor {
    public IndexingInputs(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.search.allConcreteFields()) {
            ScriptExpression script = field.getIndexingScript();
            if (script == null) continue;
            String fieldName = field.getName();
            script = (ScriptExpression)new DefaultToCurrentField(fieldName).convert((Expression)script);
            script = (ScriptExpression)new EnsureInputExpression(fieldName).convert((Expression)script);
            if (validate) {
                new VerifyInputExpression(this.search, field).visit((Expression)script);
            }
            field.setIndexingScript(script);
        }
    }

    private class VerifyInputExpression
    extends ExpressionVisitor {
        private final Search search;
        private final SDField field;

        public VerifyInputExpression(Search search, SDField field) {
            this.search = search;
            this.field = field;
        }

        protected void doVisit(Expression exp) {
            if (!(exp instanceof InputExpression)) {
                return;
            }
            String inputField = ((InputExpression)exp).getFieldName();
            if (this.search.getField(inputField).hasFullIndexingDocprocRights()) {
                return;
            }
            IndexingInputs.this.fail(this.search, this.field, "Indexing script refers to field '" + inputField + "' which does not exist in document type '" + this.search.getDocument().getName() + "', and is not a mutable attribute.");
        }
    }

    private static class EnsureInputExpression
    extends ExpressionConverter {
        final String fieldName;

        EnsureInputExpression(String fieldName) {
            this.fieldName = fieldName;
        }

        protected boolean shouldConvert(Expression exp) {
            return exp instanceof StatementExpression;
        }

        protected Expression doConvert(Expression exp) {
            if (exp.requiredInputType() != null) {
                return new StatementExpression(new Expression[]{new InputExpression(this.fieldName), exp});
            }
            return exp;
        }
    }

    private static class DefaultToCurrentField
    extends ExpressionConverter {
        final String fieldName;

        DefaultToCurrentField(String fieldName) {
            this.fieldName = fieldName;
        }

        protected boolean shouldConvert(Expression exp) {
            return exp instanceof InputExpression && ((InputExpression)exp).getFieldName() == null;
        }

        protected Expression doConvert(Expression exp) {
            return new InputExpression(this.fieldName);
        }
    }
}

