/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.storagecluster;

import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.cluster.ContentCluster;

public class StorServerProducer
implements StorServerConfig.Producer {
    private final String clusterName;
    private final Integer maxMergesPerNode;
    private final Integer queueSize;
    private final boolean useBtreeDatabase;

    public StorServerProducer(String clusterName, Integer maxMergesPerNode, Integer queueSize, boolean useBtreeDatabase) {
        this.clusterName = clusterName;
        this.maxMergesPerNode = maxMergesPerNode;
        this.queueSize = queueSize;
        this.useBtreeDatabase = useBtreeDatabase;
    }

    public void getConfig(StorServerConfig.Builder builder) {
        builder.root_folder("");
        builder.is_distributor(false);
        if (this.clusterName != null) {
            builder.cluster_name(this.clusterName);
        }
        if (this.maxMergesPerNode != null) {
            builder.max_merges_per_node(this.maxMergesPerNode.intValue());
        }
        if (this.queueSize != null) {
            builder.max_merge_queue_size(this.queueSize.intValue());
        }
        builder.use_content_node_btree_bucket_db(this.useBtreeDatabase);
    }

    public static class Builder {
        StorServerProducer build(ModelElement element, boolean useBtreeDatabase) {
            ModelElement tuning = element.child("tuning");
            if (tuning == null) {
                return new StorServerProducer(ContentCluster.getClusterId(element), null, null, useBtreeDatabase);
            }
            ModelElement merges = tuning.child("merges");
            if (merges == null) {
                return new StorServerProducer(ContentCluster.getClusterId(element), null, null, useBtreeDatabase);
            }
            return new StorServerProducer(ContentCluster.getClusterId(element), merges.integerAttribute("max-per-node"), merges.integerAttribute("max-queue-size"), useBtreeDatabase);
        }
    }
}

