/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import java.util.ArrayList;
import java.util.List;

public class DispatchSpec {
    private final Integer numDispatchGroups;
    private final List<Group> groups;

    private DispatchSpec(Builder builder) {
        this.numDispatchGroups = builder.numDispatchGroups;
        this.groups = builder.groups;
    }

    public Integer getNumDispatchGroups() {
        return this.numDispatchGroups;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public boolean valid() {
        return this.numDispatchGroups != null || this.groups != null;
    }

    public static class Builder {
        private Integer numDispatchGroups;
        private List<Group> groups;

        public DispatchSpec build() {
            return new DispatchSpec(this);
        }

        public Builder setNumDispatchGroups(Integer numDispatchGroups) {
            this.numDispatchGroups = numDispatchGroups;
            return this;
        }

        public Builder setGroups(List<Group> groups) {
            this.groups = groups;
            return this;
        }
    }

    public static class Group {
        private final List<Node> nodes = new ArrayList<Node>();

        public Group addNode(Node node) {
            this.nodes.add(node);
            return this;
        }

        public List<Node> getNodes() {
            return this.nodes;
        }
    }

    public static class Node {
        private final int distributionKey;

        public Node(int distributionKey) {
            this.distributionKey = distributionKey;
        }

        public int getDistributionKey() {
            return this.distributionKey;
        }
    }
}

