/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.config.content.core.StorCommunicationmanagerConfig;
import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.content.ContentNode;
import com.yahoo.vespa.model.content.DistributorCluster;
import com.yahoo.vespa.model.content.StorageNode;
import com.yahoo.vespa.model.content.engines.PersistenceEngine;
import org.w3c.dom.Element;

public class Distributor
extends ContentNode {
    PersistenceEngine provider;

    Distributor(DistributorCluster parent, int distributionKey, Integer distributorBasePort, PersistenceEngine provider) {
        super(parent, parent.getClusterName(), StorageNode.rootFolder + parent.getClusterName() + "/distributor/" + distributionKey, distributionKey);
        this.provider = provider;
        if (distributorBasePort != null) {
            this.setBasePort(distributorBasePort);
        }
    }

    @Override
    public void getConfig(StorServerConfig.Builder builder) {
        super.getConfig(builder);
        this.provider.getConfig(builder);
    }

    @Override
    public void getConfig(StorCommunicationmanagerConfig.Builder builder) {
        super.getConfig(builder);
        builder.mbus.dispatch_on_encode(true);
    }

    @Override
    public String getStartupCommand() {
        return "exec sbin/vespa-distributord -c $VESPA_CONFIG_ID";
    }

    public static class Builder
    extends VespaDomBuilder.DomConfigProducerBuilder<Distributor> {
        ModelElement clusterXml;
        PersistenceEngine persistenceProvider;

        public Builder(ModelElement clusterXml, PersistenceEngine persistenceProvider) {
            this.clusterXml = clusterXml;
            this.persistenceProvider = persistenceProvider;
        }

        @Override
        protected Distributor doBuild(DeployState deployState, AbstractConfigProducer ancestor, Element producerSpec) {
            return new Distributor((DistributorCluster)ancestor, new ModelElement(producerSpec).integerAttribute("distribution-key"), this.clusterXml.integerAttribute("distributor-base-port"), this.persistenceProvider);
        }
    }
}

