/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.search.pagetemplates.PageTemplatesConfig;
import com.yahoo.search.pagetemplates.config.PageTemplateXMLReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PageTemplates
implements Serializable,
PageTemplatesConfig.Producer {
    private List<String> pages = new ArrayList<String>();

    public static void validate(ApplicationPackage applicationPackage) {
        List pageTemplateFiles = null;
        try {
            pageTemplateFiles = applicationPackage.getPageTemplateFiles();
            new PageTemplateXMLReader().read(pageTemplateFiles, true);
        }
        finally {
            NamedReader.closeAll((List)pageTemplateFiles);
        }
    }

    public static PageTemplates create(ApplicationPackage applicationPackage) {
        List pageTemplateFiles = null;
        try {
            pageTemplateFiles = applicationPackage.getPageTemplateFiles();
            PageTemplates pageTemplates = new PageTemplates(pageTemplateFiles);
            return pageTemplates;
        }
        finally {
            NamedReader.closeAll((List)pageTemplateFiles);
        }
    }

    public PageTemplates(List<NamedReader> readers) {
        for (NamedReader pageReader : readers) {
            try {
                this.pages.add(this.contentAsString((Reader)pageReader));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read page template '" + pageReader.getName() + "'", e);
            }
        }
    }

    public void getConfig(PageTemplatesConfig.Builder builder) {
        for (String page : this.pages) {
            builder.page(page);
        }
    }

    private String contentAsString(Reader pageReader) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(pageReader);
        StringBuilder b = new StringBuilder();
        while (null != (line = bufferedReader.readLine())) {
            b.append(line);
            b.append("\n");
        }
        return b.toString();
    }

    public String toString() {
        return this.pages.toString();
    }

    public PageTemplatesConfig getConfig() {
        PageTemplatesConfig.Builder ptB = new PageTemplatesConfig.Builder();
        this.getConfig(ptB);
        return new PageTemplatesConfig(ptB);
    }
}

