/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Handler<CHILD extends AbstractConfigProducer<?>>
extends Component<CHILD, ComponentModel> {
    private Set<String> serverBindings = new LinkedHashSet<String>();
    private List<String> clientBindings = new ArrayList<String>();

    public Handler(ComponentModel model) {
        super(model);
    }

    public static Handler<AbstractConfigProducer<?>> fromClassName(String className) {
        return new Handler(new ComponentModel(className, null, null, null));
    }

    public static Handler<AbstractConfigProducer<?>> getVespaHandlerFromClassName(String className) {
        return new Handler(new ComponentModel(BundleInstantiationSpecification.getInternalHandlerSpecificationFromStrings((String)className, null), null));
    }

    public void addServerBindings(String ... bindings) {
        this.serverBindings.addAll(Arrays.asList(bindings));
    }

    public void removeServerBinding(String binding) {
        this.serverBindings.remove(binding);
    }

    public void addClientBindings(String ... bindings) {
        this.clientBindings.addAll(Arrays.asList(bindings));
    }

    public final Set<String> getServerBindings() {
        return Collections.unmodifiableSet(this.serverBindings);
    }

    public final List<String> getClientBindings() {
        return Collections.unmodifiableList(this.clientBindings);
    }
}

