/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.config.provision.NodeResources;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.search.config.QrStartConfig;

public class NodeResourcesTuning
implements QrStartConfig.Producer,
ThreadpoolConfig.Producer {
    private final NodeResources resources;
    private double threadPoolSizeFactor = 8.0;
    private double queueSizeFactor = 8.0;

    public NodeResourcesTuning setThreadPoolSizeFactor(double threadPoolSizeFactor) {
        this.threadPoolSizeFactor = threadPoolSizeFactor;
        return this;
    }

    public NodeResourcesTuning setQueueSizeFactor(double queueSizeFactor) {
        this.queueSizeFactor = queueSizeFactor;
        return this;
    }

    NodeResourcesTuning(NodeResources resources) {
        this.resources = resources;
    }

    public void getConfig(QrStartConfig.Builder builder) {
        builder.jvm.availableProcessors(Math.max(2, (int)Math.ceil(this.resources.vcpu())));
    }

    public void getConfig(ThreadpoolConfig.Builder builder) {
        int workerThreads = Math.max(2, (int)Math.ceil(this.resources.vcpu() * this.threadPoolSizeFactor));
        builder.maxthreads(workerThreads);
        builder.queueSize((int)((double)workerThreads * this.queueSizeFactor));
    }
}

