/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.monitoring;

import com.yahoo.vespa.model.admin.monitoring.CloudWatch;
import com.yahoo.vespa.model.admin.monitoring.Metric;
import com.yahoo.vespa.model.admin.monitoring.MetricSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MetricsConsumer {
    private final String id;
    private final MetricSet metricSet;
    private final List<CloudWatch> cloudWatches = new ArrayList<CloudWatch>();

    public MetricsConsumer(String id, MetricSet metricSet) {
        this.id = Objects.requireNonNull(id, "A consumer must have a non-null id.");
        this.metricSet = Objects.requireNonNull(metricSet, "A consumer must have a non-null metric set.");
    }

    public String getId() {
        return this.id;
    }

    public MetricSet getMetricSet() {
        return this.metricSet;
    }

    public Map<String, Metric> getMetrics() {
        return this.metricSet.getMetrics();
    }

    public void addCloudWatch(CloudWatch cloudWatch) {
        this.cloudWatches.add(cloudWatch);
    }

    public List<CloudWatch> cloudWatches() {
        return Collections.unmodifiableList(this.cloudWatches);
    }
}

