/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.document.Field;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.searchdefinition.DocumentReference;
import com.yahoo.searchdefinition.DocumentReferences;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.vespa.objects.FieldBase;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DocumentReferenceResolver {
    private final Map<String, Search> searchMapping;

    public DocumentReferenceResolver(List<Search> schemas) {
        this.searchMapping = DocumentReferenceResolver.createDocumentNameToSearchMapping(schemas);
    }

    public void resolveReferences(SDDocumentType documentType) {
        DocumentReferences references = new DocumentReferences(this.createFieldToDocumentReferenceMapping(documentType));
        documentType.setDocumentReferences(references);
    }

    private Map<String, DocumentReference> createFieldToDocumentReferenceMapping(SDDocumentType documentType) {
        return DocumentReferenceResolver.fieldStream(documentType).filter(field -> field.getDataType() instanceof ReferenceDataType).collect(Collectors.toMap(FieldBase::getName, this::createDocumentReference));
    }

    private DocumentReference createDocumentReference(Field field) {
        if (!DocumentReferenceResolver.isAttribute(field)) {
            throw new IllegalArgumentException(String.format("The field '%s' is an invalid document reference. The field must be an attribute.", field.getName()));
        }
        ReferenceDataType reference = (ReferenceDataType)field.getDataType();
        String targetDocumentName = DocumentReferenceResolver.getTargetDocumentName(reference);
        Search search = this.searchMapping.get(targetDocumentName);
        if (search == null) {
            throw new IllegalArgumentException(String.format("Invalid document reference '%s': Could not find document type '%s'", field.getName(), targetDocumentName));
        }
        return new DocumentReference(field, search);
    }

    private static boolean isAttribute(Field field) {
        SDField sdField = (SDField)field;
        return sdField.doesAttributing();
    }

    private static Map<String, Search> createDocumentNameToSearchMapping(List<Search> searchDefintions) {
        return searchDefintions.stream().filter(search -> search.getDocument() != null).collect(Collectors.toMap(search -> search.getDocument().getName(), Function.identity()));
    }

    private static Stream<Field> fieldStream(SDDocumentType documentType) {
        return documentType.getDocumentType().getFields().stream();
    }

    private static String getTargetDocumentName(ReferenceDataType reference) {
        return reference.getTargetType().getName();
    }
}

