/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml.document;

import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Component;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import org.w3c.dom.Element;

public class DocumentFactoryBuilder {
    private static final String CONCRETE_DOC_FACTORY_CLASS = "ConcreteDocumentFactory";

    public static void buildDocumentFactories(ContainerCluster cluster, Element spec) {
        LinkedHashMap<String, CallSite> types = new LinkedHashMap<String, CallSite>();
        for (Element e : XML.getChildren((Element)spec, (String)"document")) {
            String type = e.getAttribute("type");
            String clazz = e.getAttribute("class");
            if (clazz.indexOf(46) < 0) {
                throw new IllegalArgumentException("Malformed class for <document> binding, must be a full class with package: " + clazz);
            }
            String pkg = clazz.substring(0, clazz.lastIndexOf(46));
            String concDocFactory = pkg + ".ConcreteDocumentFactory";
            String bundle = e.getAttribute("bundle");
            Component component = new Component(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)concDocFactory, (String)concDocFactory, (String)bundle)));
            if (!cluster.getComponentsMap().containsKey(component.getComponentId())) {
                cluster.addComponent(component);
            }
            types.put(type, (CallSite)((Object)concDocFactory));
        }
        cluster.concreteDocumentTypes().putAll(types);
    }
}

