/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.document.DataType;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.indexinglanguage.ValueTransformProvider;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;

public abstract class TypedTransformProvider
extends ValueTransformProvider {
    private final Search search;
    private DataType fieldType;

    TypedTransformProvider(Class<? extends Expression> transformClass, Search search) {
        super(transformClass);
        this.search = search;
    }

    protected final boolean requiresTransform(Expression exp) {
        if (exp instanceof OutputExpression) {
            String fieldName = ((OutputExpression)exp).getFieldName();
            if (exp instanceof AttributeExpression) {
                Attribute attribute = this.search.getAttribute(fieldName);
                if (attribute == null) {
                    throw new IllegalArgumentException("Attribute '" + fieldName + "' not found.");
                }
                this.fieldType = attribute.getDataType();
            } else if (exp instanceof IndexExpression) {
                SDField field = this.search.getConcreteField(fieldName);
                if (field == null) {
                    throw new IllegalArgumentException("Index field '" + fieldName + "' not found.");
                }
                this.fieldType = field.getDataType();
            } else if (exp instanceof SummaryExpression) {
                SummaryField field = this.search.getSummaryField(fieldName);
                if (field == null) {
                    throw new IllegalArgumentException("Summary field '" + fieldName + "' not found.");
                }
                this.fieldType = field.getDataType();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return this.requiresTransform(exp, this.fieldType);
    }

    protected final Expression newTransform() {
        return this.newTransform(this.fieldType);
    }

    protected abstract boolean requiresTransform(Expression var1, DataType var2);

    protected abstract Expression newTransform(DataType var1);
}

