/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.provision;

import com.yahoo.collections.ListMap;
import com.yahoo.collections.Pair;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.provision.Host;
import com.yahoo.config.model.provision.Hosts;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterResources;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.ProvisionLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class InMemoryProvisioner
implements HostProvisioner {
    private static final NodeResources defaultResources = new NodeResources(1.0, 3.0, 9.0, 1.0);
    private final boolean failOnOutOfCapacity;
    private final Set<String> retiredHostNames;
    private final ListMap<NodeResources, Host> freeNodes = new ListMap();
    private final Map<ClusterSpec, List<HostSpec>> allocations = new LinkedHashMap<ClusterSpec, List<HostSpec>>();
    private final Map<Pair<ClusterSpec.Type, ClusterSpec.Id>, Integer> nextIndexInCluster = new HashMap<Pair<ClusterSpec.Type, ClusterSpec.Id>, Integer>();
    private final int startIndexForClusters;
    private final boolean useMaxResources;
    private Provisioned provisioned = new Provisioned();

    public InMemoryProvisioner(int nodeCount) {
        this(nodeCount, defaultResources);
    }

    public InMemoryProvisioner(int nodeCount, NodeResources resources) {
        this(Map.of(resources, InMemoryProvisioner.createHostInstances(nodeCount)), true, false, 0, new String[0]);
    }

    public InMemoryProvisioner(boolean failOnOutOfCapacity, String ... hosts) {
        this(Map.of(defaultResources, InMemoryProvisioner.toHostInstances(hosts)), failOnOutOfCapacity, false, 0, new String[0]);
    }

    public InMemoryProvisioner(Hosts hosts, boolean failOnOutOfCapacity, String ... retiredHostNames) {
        this(Map.of(defaultResources, hosts.asCollection()), failOnOutOfCapacity, false, 0, retiredHostNames);
    }

    public InMemoryProvisioner(Hosts hosts, boolean failOnOutOfCapacity, int startIndexForClusters, String ... retiredHostNames) {
        this(Map.of(defaultResources, hosts.asCollection()), failOnOutOfCapacity, false, startIndexForClusters, retiredHostNames);
    }

    public InMemoryProvisioner(Map<NodeResources, Collection<Host>> hosts, boolean failOnOutOfCapacity, boolean useMaxResources, int startIndexForClusters, String ... retiredHostNames) {
        this.failOnOutOfCapacity = failOnOutOfCapacity;
        this.useMaxResources = useMaxResources;
        for (Map.Entry<NodeResources, Collection<Host>> hostsWithResources : hosts.entrySet()) {
            for (Host host : hostsWithResources.getValue()) {
                this.freeNodes.put((Object)hostsWithResources.getKey(), (Object)host);
            }
        }
        this.retiredHostNames = Set.of(retiredHostNames);
        this.startIndexForClusters = startIndexForClusters;
    }

    private static Collection<Host> toHostInstances(String[] hostnames) {
        return Arrays.stream(hostnames).map(Host::new).collect(Collectors.toList());
    }

    private static Collection<Host> createHostInstances(int hostCount) {
        return IntStream.range(1, hostCount + 1).mapToObj(i -> new Host("host" + i)).collect(Collectors.toList());
    }

    public Map<ClusterSpec, List<HostSpec>> allocations() {
        return this.allocations;
    }

    public HostSpec allocateHost(String alias) {
        List defaultHosts = this.freeNodes.get((Object)defaultResources);
        if (defaultHosts.isEmpty()) {
            throw new IllegalArgumentException("No more hosts with default resources available");
        }
        Host newHost = (Host)this.freeNodes.removeValue((Object)defaultResources, 0);
        return new HostSpec(newHost.hostname(), List.of(alias), Optional.empty());
    }

    public List<HostSpec> prepare(ClusterSpec cluster, Capacity requested, ProvisionLogger logger) {
        this.provisioned.add(cluster.id(), requested);
        if (this.useMaxResources) {
            return this.prepare(cluster, requested.maxResources(), requested.isRequired(), requested.canFail());
        }
        return this.prepare(cluster, requested.minResources(), requested.isRequired(), requested.canFail());
    }

    public List<HostSpec> prepare(ClusterSpec cluster, ClusterResources requested, boolean required, boolean canFail) {
        if (cluster.group().isPresent() && requested.groups() > 1) {
            throw new IllegalArgumentException("Cannot both be specifying a group and ask for groups to be created");
        }
        int capacity = this.failOnOutOfCapacity || required ? requested.nodes() : Math.min(requested.nodes(), this.freeNodes.get((Object)defaultResources).size() + this.totalAllocatedTo(cluster));
        int groups = requested.groups() > capacity ? capacity : requested.groups();
        ArrayList<HostSpec> allocation = new ArrayList<HostSpec>();
        if (groups == 1) {
            allocation.addAll(this.allocateHostGroup(cluster.with(Optional.of(ClusterSpec.Group.from((int)0))), requested.nodeResources(), capacity, this.startIndexForClusters, canFail));
        } else {
            for (int i = 0; i < groups; ++i) {
                allocation.addAll(this.allocateHostGroup(cluster.with(Optional.of(ClusterSpec.Group.from((int)i))), requested.nodeResources(), capacity / groups, allocation.size(), canFail));
            }
        }
        ListIterator<HostSpec> i = allocation.listIterator();
        while (i.hasNext()) {
            HostSpec host = (HostSpec)i.next();
            if (!this.retiredHostNames.contains(host.hostname())) continue;
            i.set(this.retire(host));
        }
        return allocation;
    }

    public Provisioned startProvisionedRecording() {
        this.provisioned = new Provisioned();
        return this.provisioned;
    }

    private HostSpec retire(HostSpec host) {
        return new HostSpec(host.hostname(), host.realResources(), host.advertisedResources(), host.requestedResources().orElse(NodeResources.unspecified()), ((ClusterMembership)host.membership().get()).retire(), host.version(), Optional.empty(), host.dockerImageRepo());
    }

    private List<HostSpec> allocateHostGroup(ClusterSpec clusterGroup, NodeResources requestedResources, int nodesInGroup, int startIndex, boolean canFail) {
        List allocation = this.allocations.getOrDefault(clusterGroup, new ArrayList());
        this.allocations.put(clusterGroup, allocation);
        for (int i = allocation.size() - 1; i >= 0; --i) {
            NodeResources currentResources = ((HostSpec)allocation.get(0)).advertisedResources();
            if (currentResources.isUnspecified() || requestedResources.isUnspecified() || currentResources.compatibleWith(requestedResources)) continue;
            HostSpec removed = (HostSpec)allocation.remove(i);
            this.freeNodes.put((Object)currentResources, (Object)new Host(removed.hostname()));
        }
        int nextIndex = this.nextIndexInCluster.getOrDefault(new Pair((Object)clusterGroup.type(), (Object)clusterGroup.id()), startIndex);
        while (allocation.size() < nodesInGroup) {
            Optional<NodeResources> hostResources = this.freeNodes.keySet().stream().sorted(new MemoryDiskCpu()).filter(resources -> requestedResources.isUnspecified() || resources.satisfies(requestedResources)).findFirst();
            if (hostResources.isEmpty()) {
                if (!canFail) break;
                throw new IllegalArgumentException("Insufficient capacity of for " + requestedResources);
            }
            Host newHost = (Host)this.freeNodes.removeValue((Object)hostResources.get(), 0);
            if (this.freeNodes.get((Object)hostResources.get()).isEmpty()) {
                this.freeNodes.removeAll((Object)hostResources.get());
            }
            ClusterMembership membership = ClusterMembership.from((ClusterSpec)clusterGroup, (int)nextIndex++);
            allocation.add(new HostSpec(newHost.hostname(), hostResources.get(), hostResources.get(), requestedResources, membership, newHost.version(), Optional.empty(), Optional.empty()));
        }
        this.nextIndexInCluster.put((Pair<ClusterSpec.Type, ClusterSpec.Id>)new Pair((Object)clusterGroup.type(), (Object)clusterGroup.id()), nextIndex);
        while (allocation.size() > nodesInGroup) {
            allocation.remove(0);
        }
        return allocation;
    }

    private int totalAllocatedTo(ClusterSpec cluster) {
        int count = 0;
        for (Map.Entry<ClusterSpec, List<HostSpec>> allocation : this.allocations.entrySet()) {
            if (!allocation.getKey().type().equals((Object)cluster.type()) || !allocation.getKey().id().equals((Object)cluster.id())) continue;
            count += allocation.getValue().size();
        }
        return count;
    }

    private static class MemoryDiskCpu
    implements Comparator<NodeResources> {
        private MemoryDiskCpu() {
        }

        @Override
        public int compare(NodeResources a, NodeResources b) {
            if (a.memoryGb() > b.memoryGb()) {
                return 1;
            }
            if (a.memoryGb() < b.memoryGb()) {
                return -1;
            }
            if (a.diskGb() > b.diskGb()) {
                return 1;
            }
            if (a.diskGb() < b.diskGb()) {
                return -1;
            }
            if (a.vcpu() > b.vcpu()) {
                return 1;
            }
            if (a.vcpu() < b.vcpu()) {
                return -1;
            }
            return 0;
        }
    }
}

