/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.handler.ThreadPoolProvider;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.time.Duration;

public class ThreadPoolExecutorComponent
extends SimpleComponent
implements ThreadpoolConfig.Producer {
    private final String name;
    private final Integer maxPoolSize;
    private final Integer corePoolSize;
    private final Duration keepAliveTime;
    private final Integer queueSize;
    private final Duration maxThreadExecutionTime;

    private ThreadPoolExecutorComponent(Builder builder) {
        super(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)("threadpool-provider@" + builder.name), (String)ThreadPoolProvider.class.getName(), null)));
        this.name = builder.name;
        this.maxPoolSize = builder.maxPoolSize;
        this.corePoolSize = builder.corePoolSize;
        this.keepAliveTime = builder.keepAliveTime;
        this.queueSize = builder.queueSize;
        this.maxThreadExecutionTime = builder.maxThreadExecutionTime;
    }

    public void getConfig(ThreadpoolConfig.Builder builder) {
        builder.name(this.name);
        if (this.maxPoolSize != null) {
            builder.maxthreads(this.maxPoolSize.intValue());
        }
        if (this.corePoolSize != null) {
            builder.corePoolSize(this.corePoolSize.intValue());
        }
        if (this.keepAliveTime != null) {
            builder.keepAliveTime((double)this.keepAliveTime.toMillis() / 1000.0);
        }
        if (this.queueSize != null) {
            builder.queueSize(this.queueSize.intValue());
        }
        if (this.maxThreadExecutionTime != null) {
            builder.maxThreadExecutionTimeSeconds((int)this.maxThreadExecutionTime.toMillis() / 1000);
        }
    }

    public static class Builder {
        private final String name;
        private Integer maxPoolSize;
        private Integer corePoolSize;
        private Duration keepAliveTime;
        private Integer queueSize;
        private Duration maxThreadExecutionTime;

        public Builder(String name) {
            this.name = name;
        }

        public Builder maxPoolSize(int size) {
            this.maxPoolSize = size;
            return this;
        }

        public Builder corePoolSize(int size) {
            this.corePoolSize = size;
            return this;
        }

        public Builder keepAliveTime(Duration time) {
            this.keepAliveTime = time;
            return this;
        }

        public Builder queueSize(int size) {
            this.queueSize = size;
            return this;
        }

        public Builder maxThreadExecutionTime(Duration time) {
            this.maxThreadExecutionTime = time;
            return this;
        }

        public ThreadPoolExecutorComponent build() {
            return new ThreadPoolExecutorComponent(this);
        }
    }
}

