/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.clients;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Handler;
import java.util.Collection;
import java.util.Collections;

public class ContainerDocumentApi {
    private static final String vespaClientBundleSpecification = "vespaclient-container-plugin";
    private final Options options;

    public ContainerDocumentApi(ContainerCluster cluster, Options options) {
        this.options = options;
        this.setupHandlers(cluster);
    }

    private void setupHandlers(ContainerCluster cluster) {
        cluster.addComponent(this.newVespaClientHandler("com.yahoo.document.restapi.resource.RestApi", "document/v1/*"));
        cluster.addComponent(this.newVespaClientHandler("com.yahoo.vespa.http.server.FeedHandler", "reserved-for-internal-use/feedapi"));
    }

    private Handler<AbstractConfigProducer<?>> newVespaClientHandler(String componentId, String bindingSuffix) {
        Handler handler = new Handler(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)componentId, null, (String)vespaClientBundleSpecification), ""));
        for (String rootBinding : this.options.bindings) {
            handler.addServerBindings(rootBinding + bindingSuffix, rootBinding + bindingSuffix + "/");
        }
        return handler;
    }

    public static final class Options {
        private final Collection<String> bindings;

        public Options(Collection<String> bindings) {
            this.bindings = Collections.unmodifiableCollection(bindings);
        }
    }
}

