/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.FieldTypeAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.HashSet;
import java.util.Set;

public class IndexingValidation
extends Processor {
    IndexingValidation(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        VerificationContext context = new VerificationContext((FieldTypeAdapter)new MyAdapter(this.search));
        for (SDField field : this.search.allConcreteFields()) {
            ScriptExpression script = field.getIndexingScript();
            try {
                script.verify(context);
                MyConverter converter = new MyConverter();
                for (StatementExpression exp : script) {
                    converter.convert((Expression)exp);
                }
            }
            catch (VerificationException e) {
                this.fail(this.search, field, "For expression '" + e.getExpression() + "': " + e.getMessage());
            }
        }
    }

    private static class MyAdapter
    implements FieldTypeAdapter {
        final Search search;

        MyAdapter(Search search) {
            this.search = search;
        }

        public DataType getInputType(Expression exp, String fieldName) {
            SDField field = this.search.getDocumentField(fieldName);
            if (field == null) {
                throw new VerificationException(exp, "Input field '" + fieldName + "' not found.");
            }
            return field.getDataType();
        }

        public void tryOutputType(Expression exp, String fieldName, DataType valueType) {
            DataType fieldType;
            String fieldDesc;
            if (exp instanceof AttributeExpression) {
                Attribute attribute = this.search.getAttribute(fieldName);
                if (attribute == null) {
                    throw new VerificationException(exp, "Attribute '" + fieldName + "' not found.");
                }
                fieldDesc = "attribute";
                fieldType = attribute.getDataType();
            } else if (exp instanceof IndexExpression) {
                SDField field = this.search.getConcreteField(fieldName);
                if (field == null) {
                    throw new VerificationException(exp, "Index field '" + fieldName + "' not found.");
                }
                fieldDesc = "index field";
                fieldType = field.getDataType();
            } else if (exp instanceof SummaryExpression) {
                SummaryField field = this.search.getSummaryField(fieldName);
                if (field == null) {
                    throw new VerificationException(exp, "Summary field '" + fieldName + "' not found.");
                }
                fieldDesc = "summary field";
                fieldType = field.getDataType();
            } else {
                throw new UnsupportedOperationException();
            }
            if (!fieldType.isAssignableFrom(valueType) && !fieldType.isAssignableFrom(MyAdapter.createCompatType(valueType))) {
                throw new VerificationException(exp, "Can not assign " + valueType.getName() + " to " + fieldDesc + " '" + fieldName + "' which is " + fieldType.getName() + ".");
            }
        }

        private static DataType createCompatType(DataType origType) {
            if (origType instanceof ArrayDataType) {
                return DataType.getArray((DataType)MyAdapter.createCompatType(((ArrayDataType)origType).getNestedType()));
            }
            if (origType instanceof MapDataType) {
                MapDataType mapType = (MapDataType)origType;
                return DataType.getMap((DataType)MyAdapter.createCompatType(mapType.getKeyType()), (DataType)MyAdapter.createCompatType(mapType.getValueType()));
            }
            if (origType instanceof WeightedSetDataType) {
                return DataType.getWeightedSet((DataType)MyAdapter.createCompatType(((WeightedSetDataType)origType).getNestedType()));
            }
            if (origType == PositionDataType.INSTANCE) {
                return DataType.LONG;
            }
            return origType;
        }
    }

    private static class MyConverter
    extends ExpressionConverter {
        final Set<String> outputs = new HashSet<String>();
        final Set<String> prevNames = new HashSet<String>();

        private MyConverter() {
        }

        protected ExpressionConverter branch() {
            MyConverter ret = new MyConverter();
            ret.outputs.addAll(this.outputs);
            ret.prevNames.addAll(this.prevNames);
            return ret;
        }

        protected boolean shouldConvert(Expression exp) {
            if (exp instanceof OutputExpression) {
                String fieldName = ((OutputExpression)exp).getFieldName();
                if (this.outputs.contains(fieldName) && !this.prevNames.contains(fieldName)) {
                    throw new VerificationException(exp, "Attempting to assign conflicting values to field '" + fieldName + "'.");
                }
                this.outputs.add(fieldName);
                this.prevNames.add(fieldName);
            }
            if (exp.createdOutputType() != null) {
                this.prevNames.clear();
            }
            return false;
        }

        protected Expression doConvert(Expression exp) {
            throw new UnsupportedOperationException();
        }
    }
}

