/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.document;

import java.util.Optional;

public class HnswIndexParams {
    public static final int DEFAULT_MAX_LINKS_PER_NODE = 16;
    public static final int DEFAULT_NEIGHBORS_TO_EXPLORE_AT_INSERT = 200;
    private final Optional<Integer> maxLinksPerNode;
    private final Optional<Integer> neighborsToExploreAtInsert;

    public HnswIndexParams() {
        this.maxLinksPerNode = Optional.empty();
        this.neighborsToExploreAtInsert = Optional.empty();
    }

    public HnswIndexParams(Optional<Integer> maxLinksPerNode, Optional<Integer> neighborsToExploreAtInsert) {
        this.maxLinksPerNode = maxLinksPerNode;
        this.neighborsToExploreAtInsert = neighborsToExploreAtInsert;
    }

    public HnswIndexParams overrideFrom(Optional<HnswIndexParams> other) {
        if (!other.isPresent()) {
            return this;
        }
        HnswIndexParams rhs = other.get();
        return new HnswIndexParams(rhs.maxLinksPerNode.or(() -> this.maxLinksPerNode), rhs.neighborsToExploreAtInsert.or(() -> this.neighborsToExploreAtInsert));
    }

    public int maxLinksPerNode() {
        return this.maxLinksPerNode.orElse(16);
    }

    public int neighborsToExploreAtInsert() {
        return this.neighborsToExploreAtInsert.orElse(200);
    }

    public static class Builder {
        private Optional<Integer> maxLinksPerNode = Optional.empty();
        private Optional<Integer> neighborsToExploreAtInsert = Optional.empty();

        public void setMaxLinksPerNode(int value) {
            this.maxLinksPerNode = Optional.of(value);
        }

        public void setNeighborsToExploreAtInsert(int value) {
            this.neighborsToExploreAtInsert = Optional.of(value);
        }

        public HnswIndexParams build() {
            return new HnswIndexParams(this.maxLinksPerNode, this.neighborsToExploreAtInsert);
        }
    }
}

