/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.text.Lowercase;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import com.yahoo.vespa.model.content.DispatchTuning;

public class Tuning
extends AbstractConfigProducer
implements ProtonConfig.Producer {
    public DispatchTuning dispatch = DispatchTuning.empty;
    public SearchNode searchNode;

    public Tuning(AbstractConfigProducer parent) {
        super(parent, "tuning");
    }

    public void getConfig(ProtonConfig.Builder builder) {
        if (this.searchNode != null) {
            this.searchNode.getConfig(builder);
        }
    }

    public int getNumThreadsPerSearch() {
        if (this.searchNode == null) {
            return 1;
        }
        if (this.searchNode.threads == null) {
            return 1;
        }
        if (this.searchNode.threads.numThreadsPerSearch == null) {
            return 1;
        }
        return this.searchNode.threads.numThreadsPerSearch;
    }

    public static class SearchNode
    implements ProtonConfig.Producer {
        public RequestThreads threads = null;
        public FlushStrategy strategy = null;
        public Resizing resizing = null;
        public Index index = null;
        public Attribute attribute = null;
        public Summary summary = null;
        public Initialize initialize = null;
        public Feeding feeding = null;
        public RemovedDB removedDB = null;

        public void getConfig(ProtonConfig.Builder builder) {
            if (this.threads != null) {
                this.threads.getConfig(builder);
            }
            if (this.strategy != null) {
                this.strategy.getConfig(builder);
            }
            if (this.resizing != null) {
                this.resizing.getConfig(builder);
            }
            if (this.index != null) {
                this.index.getConfig(builder);
            }
            if (this.attribute != null) {
                this.attribute.getConfig(builder);
            }
            if (this.summary != null) {
                this.summary.getConfig(builder);
            }
            if (this.initialize != null) {
                this.initialize.getConfig(builder);
            }
            if (this.feeding != null) {
                this.feeding.getConfig(builder);
            }
            if (this.removedDB != null) {
                this.removedDB.getConfig(builder);
            }
        }

        public static class Feeding
        implements ProtonConfig.Producer {
            public Double concurrency = null;

            public void getConfig(ProtonConfig.Builder builder) {
                if (this.concurrency != null) {
                    builder.feeding.concurrency(this.concurrency / 2.0);
                }
            }
        }

        public static class Initialize
        implements ProtonConfig.Producer {
            public Integer threads = null;

            public void getConfig(ProtonConfig.Builder builder) {
                if (this.threads != null) {
                    builder.initialize.threads(this.threads.intValue());
                }
            }
        }

        public static class Summary
        implements ProtonConfig.Producer {
            public Io io;
            public Store store;

            public void getConfig(ProtonConfig.Builder builder) {
                if (this.io != null) {
                    this.io.getConfig(builder.summary);
                }
                if (this.store != null) {
                    this.store.getConfig(builder.summary);
                }
            }

            public static class Store {
                public Component cache;
                public LogStore logStore;

                public void getConfig(ProtonConfig.Summary.Builder builder) {
                    if (this.cache != null) {
                        this.cache.getConfig(builder.cache);
                    }
                    if (this.logStore != null) {
                        this.logStore.getConfig(builder.log);
                    }
                }

                public static class LogStore {
                    public Long maxFileSize = null;
                    public Component chunk = null;
                    public Double minFileSizeFactor = null;

                    public void getConfig(ProtonConfig.Summary.Log.Builder log) {
                        if (this.maxFileSize != null) {
                            log.maxfilesize(this.maxFileSize.longValue());
                        }
                        if (this.minFileSizeFactor != null) {
                            log.minfilesizefactor(this.minFileSizeFactor.doubleValue());
                        }
                        if (this.chunk != null) {
                            this.chunk.getConfig(log.chunk);
                            this.chunk.getConfig(log.compact);
                        }
                    }
                }

                public static class Component {
                    public Long maxSize = null;
                    public Double maxSizePercent = null;
                    public Long initialEntries = null;
                    public Compression compression = null;
                    private final boolean outputInt;

                    public Component() {
                        this.outputInt = false;
                    }

                    public Component(boolean outputInt) {
                        this.outputInt = outputInt;
                    }

                    public void getConfig(ProtonConfig.Summary.Cache.Builder cache) {
                        if (this.outputInt) {
                            if (this.maxSizePercent != null) {
                                cache.maxbytes(-this.maxSizePercent.longValue());
                            }
                            if (this.maxSize != null) {
                                cache.maxbytes((long)this.maxSize.intValue());
                            }
                            if (this.initialEntries != null) {
                                cache.initialentries((long)this.initialEntries.intValue());
                            }
                        } else {
                            if (this.maxSizePercent != null) {
                                cache.maxbytes(-this.maxSizePercent.longValue());
                            }
                            if (this.maxSize != null) {
                                cache.maxbytes(this.maxSize.longValue());
                            }
                            if (this.initialEntries != null) {
                                cache.initialentries(this.initialEntries.longValue());
                            }
                        }
                        if (this.compression != null) {
                            this.compression.getConfig(cache.compression);
                        }
                    }

                    public void getConfig(ProtonConfig.Summary.Log.Compact.Builder compact) {
                        if (this.compression != null) {
                            this.compression.getConfig(compact.compression);
                        }
                    }

                    public void getConfig(ProtonConfig.Summary.Log.Chunk.Builder chunk) {
                        if (this.outputInt) {
                            if (this.maxSize != null) {
                                chunk.maxbytes(this.maxSize.intValue());
                            }
                        } else {
                            throw new IllegalStateException("Fix this, chunk does not have long types");
                        }
                        if (this.compression != null) {
                            this.compression.getConfig(chunk.compression);
                        }
                    }
                }

                public static class Compression {
                    public Type type = null;
                    public Integer level = null;

                    public void getConfig(ProtonConfig.Summary.Cache.Compression.Builder compression) {
                        if (this.type != null) {
                            compression.type(ProtonConfig.Summary.Cache.Compression.Type.Enum.valueOf((String)this.type.name));
                        }
                        if (this.level != null) {
                            compression.level(this.level.intValue());
                        }
                    }

                    public void getConfig(ProtonConfig.Summary.Log.Compact.Compression.Builder compression) {
                        if (this.type != null) {
                            compression.type(ProtonConfig.Summary.Log.Compact.Compression.Type.Enum.valueOf((String)this.type.name));
                        }
                        if (this.level != null) {
                            compression.level(this.level.intValue());
                        }
                    }

                    public void getConfig(ProtonConfig.Summary.Log.Chunk.Compression.Builder compression) {
                        if (this.type != null) {
                            compression.type(ProtonConfig.Summary.Log.Chunk.Compression.Type.Enum.valueOf((String)this.type.name));
                        }
                        if (this.level != null) {
                            compression.level(this.level.intValue());
                        }
                    }

                    public static enum Type {
                        NONE("NONE"),
                        ZSTD("ZSTD"),
                        LZ4("LZ4");

                        public final String name;

                        private Type(String name) {
                            this.name = name;
                        }

                        public static Type fromString(String name) {
                            for (Type type : Type.values()) {
                                if (!Lowercase.toLowerCase((String)name).equals(Lowercase.toLowerCase((String)type.name))) continue;
                                return type;
                            }
                            return NONE;
                        }
                    }
                }
            }

            public static class Io {
                public IoType write = null;
                public IoType read = null;

                public void getConfig(ProtonConfig.Summary.Builder builder) {
                    if (this.write != null) {
                        builder.write.io(ProtonConfig.Summary.Write.Io.Enum.valueOf((String)this.write.name));
                    }
                    if (this.read != null) {
                        if (this.read.equals((Object)IoType.POPULATE)) {
                            builder.read.io(ProtonConfig.Summary.Read.Io.MMAP);
                            builder.read.mmap.options.add(ProtonConfig.Summary.Read.Mmap.Options.POPULATE);
                        } else {
                            builder.read.io(ProtonConfig.Summary.Read.Io.Enum.valueOf((String)this.read.name));
                        }
                    }
                }
            }
        }

        public static class Attribute
        implements ProtonConfig.Producer {
            public Io io;

            public void getConfig(ProtonConfig.Builder builder) {
                if (this.io != null) {
                    this.io.getConfig(builder);
                }
            }

            public static class Io
            implements ProtonConfig.Producer {
                public IoType write = null;

                public void getConfig(ProtonConfig.Builder builder) {
                    if (this.write != null) {
                        builder.attribute.write.io(ProtonConfig.Attribute.Write.Io.Enum.valueOf((String)this.write.name));
                    }
                }
            }
        }

        public static class Index
        implements ProtonConfig.Producer {
            public Io io;
            public Warmup warmup;

            public void getConfig(ProtonConfig.Builder builder) {
                if (this.io != null) {
                    this.io.getConfig(builder);
                }
                if (this.warmup != null) {
                    this.warmup.getConfig(builder);
                }
            }

            public static class Warmup
            implements ProtonConfig.Producer {
                public double time = 0.0;
                public boolean unpack = false;

                public void getConfig(ProtonConfig.Builder builder) {
                    if (this.time > 0.0) {
                        builder.index.warmup.time(this.time);
                        builder.index.warmup.unpack(this.unpack);
                    }
                }
            }

            public static class Io
            implements ProtonConfig.Producer {
                public IoType write = null;
                public IoType read = null;
                public IoType search = null;

                public void getConfig(ProtonConfig.Builder builder) {
                    if (this.write != null) {
                        builder.indexing.write.io(ProtonConfig.Indexing.Write.Io.Enum.valueOf((String)this.write.name));
                    }
                    if (this.read != null) {
                        builder.indexing.read.io(ProtonConfig.Indexing.Read.Io.Enum.valueOf((String)this.read.name));
                    }
                    if (this.search != null && this.search.equals((Object)IoType.POPULATE)) {
                        builder.search.mmap.options.add(ProtonConfig.Search.Mmap.Options.POPULATE);
                    }
                }
            }
        }

        public static class Resizing
        implements ProtonConfig.Producer {
            public Integer initialDocumentCount = null;
            public Integer amortizeCount = null;

            public void getConfig(ProtonConfig.Builder builder) {
                if (this.initialDocumentCount != null) {
                    for (ProtonConfig.Documentdb.Builder db : builder.documentdb) {
                        db.allocation.initialnumdocs((long)this.initialDocumentCount.intValue());
                    }
                }
                if (this.amortizeCount != null) {
                    for (ProtonConfig.Documentdb.Builder db : builder.documentdb) {
                        db.allocation.amortizecount(this.amortizeCount.intValue());
                    }
                }
            }
        }

        public static class FlushStrategy
        implements ProtonConfig.Producer {
            public Long totalMaxMemoryGain = null;
            public Double totalDiskBloatFactor = null;
            public Long componentMaxMemoryGain = null;
            public Double componentDiskBloatFactor = null;
            public Double componentMaxage = null;
            public Long transactionLogMaxSize = null;
            public Double conservativeMemoryLimitFactor = null;
            public Double conservativeDiskLimitFactor = null;

            public void getConfig(ProtonConfig.Builder builder) {
                ProtonConfig.Flush.Memory.Builder memoryBuilder = builder.flush.memory;
                if (this.totalMaxMemoryGain != null) {
                    memoryBuilder.maxmemory(this.totalMaxMemoryGain.longValue());
                }
                if (this.totalDiskBloatFactor != null) {
                    memoryBuilder.diskbloatfactor(this.totalDiskBloatFactor.doubleValue());
                }
                if (this.transactionLogMaxSize != null) {
                    memoryBuilder.maxtlssize(this.transactionLogMaxSize.longValue());
                }
                ProtonConfig.Flush.Memory.Each.Builder eachBuilder = memoryBuilder.each;
                if (this.componentMaxMemoryGain != null) {
                    eachBuilder.maxmemory(this.componentMaxMemoryGain.longValue());
                }
                if (this.componentDiskBloatFactor != null) {
                    eachBuilder.diskbloatfactor(this.componentDiskBloatFactor.doubleValue());
                }
                ProtonConfig.Flush.Memory.Maxage.Builder maxageBuilder = memoryBuilder.maxage;
                if (this.componentMaxage != null) {
                    maxageBuilder.time(this.componentMaxage.doubleValue());
                }
                ProtonConfig.Flush.Memory.Conservative.Builder conservativeBuilder = memoryBuilder.conservative;
                if (this.conservativeMemoryLimitFactor != null) {
                    conservativeBuilder.memorylimitfactor(this.conservativeMemoryLimitFactor.doubleValue());
                }
                if (this.conservativeDiskLimitFactor != null) {
                    conservativeBuilder.disklimitfactor(this.conservativeDiskLimitFactor.doubleValue());
                }
            }
        }

        public static class RemovedDB
        implements ProtonConfig.Producer {
            public Prune prune;

            public void getConfig(ProtonConfig.Builder builder) {
                if (this.prune != null) {
                    this.prune.getConfig(builder);
                }
            }

            public static class Prune
            implements ProtonConfig.Producer {
                public Double age = null;
                public Double interval = null;

                public void getConfig(ProtonConfig.Builder builder) {
                    if (this.age != null) {
                        builder.pruneremoveddocumentsage(this.age.doubleValue());
                    }
                    if (this.interval != null) {
                        builder.pruneremoveddocumentsinterval(this.interval.doubleValue());
                    }
                }
            }
        }

        public static class RequestThreads
        implements ProtonConfig.Producer {
            public Integer numSearchThreads = null;
            public Integer numThreadsPerSearch = null;
            public Integer numSummaryThreads = null;

            public void getConfig(ProtonConfig.Builder builder) {
                if (this.numSearchThreads != null) {
                    builder.numsearcherthreads(this.numSearchThreads.intValue());
                }
                if (this.numThreadsPerSearch != null) {
                    builder.numthreadspersearch(this.numThreadsPerSearch.intValue());
                }
                if (this.numSummaryThreads != null) {
                    builder.numsummarythreads(this.numSummaryThreads.intValue());
                }
            }
        }

        public static enum IoType {
            NORMAL("NORMAL"),
            DIRECTIO("DIRECTIO"),
            MMAP("MMAP"),
            POPULATE("POPULATE");

            public final String name;

            private IoType(String name) {
                this.name = name;
            }

            public static IoType fromString(String name) {
                for (IoType type : IoType.values()) {
                    if (!Lowercase.toLowerCase((String)name).equals(Lowercase.toLowerCase((String)type.name))) continue;
                    return type;
                }
                return NORMAL;
            }
        }
    }
}

