/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.config.provision.Flavor;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.search.config.QrStartConfig;

public class NodeFlavorTuning
implements QrStartConfig.Producer,
ThreadpoolConfig.Producer {
    private final Flavor flavor;
    private double threadPoolSizeFactor = 8.0;
    private double queueSizeFactor = 8.0;

    public NodeFlavorTuning setThreadPoolSizeFactor(double threadPoolSizeFactor) {
        this.threadPoolSizeFactor = threadPoolSizeFactor;
        return this;
    }

    public NodeFlavorTuning setQueueSizeFactor(double queueSizeFactor) {
        this.queueSizeFactor = queueSizeFactor;
        return this;
    }

    NodeFlavorTuning(Flavor flavor) {
        this.flavor = flavor;
    }

    public void getConfig(QrStartConfig.Builder builder) {
        builder.jvm.availableProcessors(Math.max(2, (int)Math.ceil(this.flavor.getMinCpuCores())));
    }

    public void getConfig(ThreadpoolConfig.Builder builder) {
        int workerThreads = Math.max(2, (int)Math.ceil(this.flavor.getMinCpuCores() * this.threadPoolSizeFactor));
        builder.maxthreads(workerThreads);
        builder.queueSize((int)((double)workerThreads * this.queueSizeFactor));
    }
}

