/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import com.google.common.collect.ImmutableList;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.TlsSecrets;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Zone;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class TestProperties
implements ModelContext.Properties {
    private boolean multitenant = false;
    private ApplicationId applicationId = ApplicationId.defaultId();
    private List<ConfigServerSpec> configServerSpecs = Collections.emptyList();
    private HostName loadBalancerName = null;
    private URI ztsUrl = null;
    private String athenzDnsSuffix = null;
    private boolean hostedVespa = false;
    private Zone zone;
    private Set<ContainerEndpoint> endpoints = Collections.emptySet();
    private boolean isBootstrap = false;
    private boolean isFirstTimeDeployment = false;
    private boolean useDedicatedNodeForLogserver = false;
    private boolean useAdaptiveDispatch = false;
    private double topKProbability = 1.0;
    private boolean useDistributorBtreeDb = false;
    private boolean useThreePhaseUpdates = false;
    private double defaultTermwiseLimit = 1.0;
    private double softStartSeconds = 0.0;
    private double threadPoolSizeFactor = 0.0;
    private double queueSizeFactor = 0.0;
    private Optional<EndpointCertificateSecrets> endpointCertificateSecrets = Optional.empty();
    private AthenzDomain athenzDomain;

    public boolean multitenant() {
        return this.multitenant;
    }

    public ApplicationId applicationId() {
        return this.applicationId;
    }

    public List<ConfigServerSpec> configServerSpecs() {
        return this.configServerSpecs;
    }

    public HostName loadBalancerName() {
        return this.loadBalancerName;
    }

    public URI ztsUrl() {
        return this.ztsUrl;
    }

    public String athenzDnsSuffix() {
        return this.athenzDnsSuffix;
    }

    public boolean hostedVespa() {
        return this.hostedVespa;
    }

    public Zone zone() {
        return this.zone;
    }

    public Set<ContainerEndpoint> endpoints() {
        return this.endpoints;
    }

    public boolean isBootstrap() {
        return this.isBootstrap;
    }

    public boolean isFirstTimeDeployment() {
        return this.isFirstTimeDeployment;
    }

    public boolean useAdaptiveDispatch() {
        return this.useAdaptiveDispatch;
    }

    public boolean useDedicatedNodeForLogserver() {
        return this.useDedicatedNodeForLogserver;
    }

    public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
        return this.endpointCertificateSecrets;
    }

    public Optional<TlsSecrets> tlsSecrets() {
        return this.endpointCertificateSecrets.map(TlsSecrets::new);
    }

    public double defaultTermwiseLimit() {
        return this.defaultTermwiseLimit;
    }

    public double threadPoolSizeFactor() {
        return this.threadPoolSizeFactor;
    }

    public double queueSizeFactor() {
        return this.queueSizeFactor;
    }

    public double defaultSoftStartSeconds() {
        return this.softStartSeconds;
    }

    public double defaultTopKProbability() {
        return this.topKProbability;
    }

    public boolean useDistributorBtreeDb() {
        return this.useDistributorBtreeDb;
    }

    public boolean useThreePhaseUpdates() {
        return this.useThreePhaseUpdates;
    }

    public boolean useBucketSpaceMetric() {
        return true;
    }

    public Optional<AthenzDomain> athenzDomain() {
        return Optional.ofNullable(this.athenzDomain);
    }

    public TestProperties setDefaultTermwiseLimit(double limit) {
        this.defaultTermwiseLimit = limit;
        return this;
    }

    public TestProperties setTopKProbability(double probability) {
        this.topKProbability = probability;
        return this;
    }

    public TestProperties setUseDistributorBtreeDB(boolean useBtreeDb) {
        this.useDistributorBtreeDb = useBtreeDb;
        return this;
    }

    public TestProperties setUseThreePhaseUpdates(boolean useThreePhaseUpdates) {
        this.useThreePhaseUpdates = useThreePhaseUpdates;
        return this;
    }

    public TestProperties setSoftStartSeconds(double softStartSeconds) {
        this.softStartSeconds = softStartSeconds;
        return this;
    }

    public TestProperties setThreadPoolSizeFactor(double threadPoolSizeFactor) {
        this.threadPoolSizeFactor = threadPoolSizeFactor;
        return this;
    }

    public TestProperties setQueueSizeFactor(double queueSizeFactor) {
        this.queueSizeFactor = queueSizeFactor;
        return this;
    }

    public TestProperties setApplicationId(ApplicationId applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public TestProperties setHostedVespa(boolean hostedVespa) {
        this.hostedVespa = hostedVespa;
        return this;
    }

    public TestProperties setUseAdaptiveDispatch(boolean useAdaptiveDispatch) {
        this.useAdaptiveDispatch = useAdaptiveDispatch;
        return this;
    }

    public TestProperties setMultitenant(boolean multitenant) {
        this.multitenant = multitenant;
        return this;
    }

    public TestProperties setConfigServerSpecs(List<Spec> configServerSpecs) {
        this.configServerSpecs = ImmutableList.copyOf(configServerSpecs);
        return this;
    }

    public TestProperties setUseDedicatedNodeForLogserver(boolean useDedicatedNodeForLogserver) {
        this.useDedicatedNodeForLogserver = useDedicatedNodeForLogserver;
        return this;
    }

    public TestProperties setEndpointCertificateSecrets(Optional<EndpointCertificateSecrets> endpointCertificateSecrets) {
        this.endpointCertificateSecrets = endpointCertificateSecrets;
        return this;
    }

    public TestProperties setZone(Zone zone) {
        this.zone = zone;
        return this;
    }

    public TestProperties setAthenzDomain(AthenzDomain domain) {
        this.athenzDomain = domain;
        return this;
    }

    public static class Spec
    implements ConfigServerSpec {
        private final String hostName;
        private final int configServerPort;
        private final int zooKeeperPort;

        public String getHostName() {
            return this.hostName;
        }

        public int getConfigServerPort() {
            return this.configServerPort;
        }

        public int getZooKeeperPort() {
            return this.zooKeeperPort;
        }

        public boolean equals(Object o) {
            if (o instanceof ConfigServerSpec) {
                ConfigServerSpec other = (ConfigServerSpec)o;
                return this.hostName.equals(other.getHostName()) && this.configServerPort == other.getConfigServerPort() && this.zooKeeperPort == other.getZooKeeperPort();
            }
            return false;
        }

        public int hashCode() {
            return this.hostName.hashCode();
        }

        public Spec(String hostName, int configServerPort, int zooKeeperPort) {
            this.hostName = hostName;
            this.configServerPort = configServerPort;
            this.zooKeeperPort = zooKeeperPort;
        }
    }
}

