/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.ssl;

import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.ssl.ConfiguredDirectSslProvider;
import com.yahoo.vespa.model.container.http.ssl.DefaultSslProvider;
import java.time.Duration;
import java.util.List;

public class HostedSslConnectorFactory
extends ConnectorFactory {
    private static final List<String> INSECURE_WHITELISTED_PATHS = List.of("/status.html");
    private static final String DEFAULT_HOSTED_TRUSTSTORE = "/opt/yahoo/share/ssl/certs/athenz_certificate_bundle.pem";
    private final boolean enforceClientAuth;
    private final String proxyProtocol;

    public static HostedSslConnectorFactory withProvidedCertificate(String proxyProtocol, String serverName, EndpointCertificateSecrets endpointCertificateSecrets) {
        return new HostedSslConnectorFactory(proxyProtocol, HostedSslConnectorFactory.createConfiguredDirectSslProvider(serverName, endpointCertificateSecrets, DEFAULT_HOSTED_TRUSTSTORE, null), false);
    }

    public static HostedSslConnectorFactory withProvidedCertificateAndTruststore(String proxyProtocol, String serverName, EndpointCertificateSecrets endpointCertificateSecrets, String tlsCaCertificates) {
        return new HostedSslConnectorFactory(proxyProtocol, HostedSslConnectorFactory.createConfiguredDirectSslProvider(serverName, endpointCertificateSecrets, null, tlsCaCertificates), true);
    }

    public static HostedSslConnectorFactory withDefaultCertificateAndTruststore(String proxyProtocol, String serverName) {
        return new HostedSslConnectorFactory(proxyProtocol, new DefaultSslProvider(serverName), true);
    }

    private HostedSslConnectorFactory(String proxyProtocol, SimpleComponent sslProviderComponent, boolean enforceClientAuth) {
        super("tls4443", 4443, sslProviderComponent);
        this.proxyProtocol = proxyProtocol;
        this.enforceClientAuth = enforceClientAuth;
    }

    private static ConfiguredDirectSslProvider createConfiguredDirectSslProvider(String serverName, EndpointCertificateSecrets endpointCertificateSecrets, String tlsCaCertificatesPath, String tlsCaCertificates) {
        return new ConfiguredDirectSslProvider(serverName, endpointCertificateSecrets.key(), endpointCertificateSecrets.certificate(), tlsCaCertificatesPath, tlsCaCertificates, ConnectorConfig.Ssl.ClientAuth.Enum.WANT_AUTH);
    }

    @Override
    public void getConfig(ConnectorConfig.Builder connectorBuilder) {
        super.getConfig(connectorBuilder);
        connectorBuilder.tlsClientAuthEnforcer(new ConnectorConfig.TlsClientAuthEnforcer.Builder().pathWhitelist(INSECURE_WHITELISTED_PATHS).enable(this.enforceClientAuth)).proxyProtocol(this.configureProxyProtocol()).idleTimeout((double)Duration.ofMinutes(3L).toSeconds()).maxConnectionLife((double)Duration.ofMinutes(10L).toSeconds());
    }

    private ConnectorConfig.ProxyProtocol.Builder configureProxyProtocol() {
        ConnectorConfig.ProxyProtocol.Builder proxyProtocolBuilder = new ConnectorConfig.ProxyProtocol.Builder();
        switch (this.proxyProtocol) {
            case "https-only": {
                return proxyProtocolBuilder.enabled(false).mixedMode(false);
            }
            case "https+proxy-protocol": {
                return proxyProtocolBuilder.enabled(true).mixedMode(true);
            }
            case "proxy-protocol-only": {
                return proxyProtocolBuilder.enabled(true).mixedMode(false);
            }
        }
        throw new IllegalArgumentException("Unknown proxy-protocol settings: " + this.proxyProtocol);
    }
}

