/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.BundlesConfig;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.container.handler.metrics.MetricsProxyApiConfig;
import com.yahoo.container.handler.metrics.MetricsV2Handler;
import com.yahoo.container.jdisc.ContainerMbusConfig;
import com.yahoo.container.jdisc.messagebus.MbusServerProvider;
import com.yahoo.jdisc.http.ServletPathsConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.container.ApplicationContainer;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerModelEvaluation;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.ConfigProducerGroup;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.Servlet;
import com.yahoo.vespa.model.container.jersey.Jersey2Servlet;
import com.yahoo.vespa.model.container.jersey.RestApi;
import com.yahoo.vespa.model.utils.FileSender;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ApplicationContainerCluster
extends ContainerCluster<ApplicationContainer>
implements BundlesConfig.Producer,
QrStartConfig.Producer,
RankProfilesConfig.Producer,
RankingConstantsConfig.Producer,
ServletPathsConfig.Producer,
ContainerMbusConfig.Producer,
MetricsProxyApiConfig.Producer {
    public static final String METRICS_V2_HANDLER_CLASS = MetricsV2Handler.class.getName();
    public static final String METRICS_V2_HANDLER_BINDING_1 = "http://*/metrics/v2";
    public static final String METRICS_V2_HANDLER_BINDING_2 = "http://*/metrics/v2/*";
    private final Set<FileReference> applicationBundles = new LinkedHashSet<FileReference>();
    private final ConfigProducerGroup<Servlet> servletGroup;
    private final ConfigProducerGroup<RestApi> restApiGroup;
    private ContainerModelEvaluation modelEvaluation;
    private Optional<String> tlsClientAuthority;
    private MbusParams mbusParams;
    private boolean messageBusEnabled = true;
    private final double softStartSeconds;
    private Integer memoryPercentage = null;

    public ApplicationContainerCluster(AbstractConfigProducer<?> parent, String subId, String name, DeployState deployState) {
        super(parent, subId, name, deployState);
        this.tlsClientAuthority = deployState.tlsClientAuthority();
        this.restApiGroup = new ConfigProducerGroup(this, "rest-api");
        this.servletGroup = new ConfigProducerGroup(this, "servlet");
        this.addSimpleComponent("com.yahoo.language.provider.DefaultLinguisticsProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.SecretStoreProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.DeprecatedSecretStoreProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.CertificateStoreProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.AthenzIdentityProviderProvider");
        this.addMetricsV2Handler();
        this.addTestrunnerComponentsIfTester(deployState);
        this.softStartSeconds = deployState.getProperties().defaultSoftStartSeconds();
    }

    @Override
    protected void doPrepare(DeployState deployState) {
        this.addAndSendApplicationBundles(deployState);
        if (this.modelEvaluation != null) {
            this.modelEvaluation.prepare(this.containers);
        }
        this.sendUserConfiguredFiles(deployState);
        for (RestApi restApi : this.restApiGroup.getComponents()) {
            restApi.prepare();
        }
    }

    private void addAndSendApplicationBundles(DeployState deployState) {
        for (ComponentInfo component : deployState.getApplicationPackage().getComponentsInfo(deployState.getVespaVersion())) {
            FileReference reference = FileSender.sendFileToServices(component.getPathRelativeToAppDir(), this.containers);
            this.applicationBundles.add(reference);
        }
    }

    private void sendUserConfiguredFiles(DeployState deployState) {
        for (Component<?, ?> component : this.getAllComponents()) {
            FileSender.sendUserConfiguredFiles(component, this.containers, deployState.getDeployLogger());
        }
    }

    public void addMetricsV2Handler() {
        Handler handler = new Handler(new ComponentModel(METRICS_V2_HANDLER_CLASS, null, null, null));
        handler.addServerBindings(METRICS_V2_HANDLER_BINDING_1, METRICS_V2_HANDLER_BINDING_2);
        this.addComponent(handler);
    }

    private void addTestrunnerComponentsIfTester(DeployState deployState) {
        if (deployState.isHosted() && deployState.getProperties().applicationId().instance().isTester()) {
            this.addPlatformBundle(Paths.get(Defaults.getDefaults().underVespaHome("lib/jars/vespa-testrunner-components-jar-with-dependencies.jar"), new String[0]));
        }
    }

    public void setModelEvaluation(ContainerModelEvaluation modelEvaluation) {
        this.modelEvaluation = modelEvaluation;
    }

    public final void addRestApi(RestApi restApi) {
        this.restApiGroup.addComponent(ComponentId.fromString((String)restApi.getBindingPath()), restApi);
    }

    public Map<ComponentId, RestApi> getRestApiMap() {
        return this.restApiGroup.getComponentMap();
    }

    public Map<ComponentId, Servlet> getServletMap() {
        return this.servletGroup.getComponentMap();
    }

    public final void addServlet(Servlet servlet) {
        this.servletGroup.addComponent(servlet.getGlobalComponentId(), servlet);
    }

    public Collection<Servlet> getAllServlets() {
        return this.allServlets().collect(Collectors.toCollection(ArrayList::new));
    }

    private Stream<Servlet> allServlets() {
        return Stream.concat(this.allJersey2Servlets(), this.servletGroup.getComponents().stream());
    }

    private Stream<Jersey2Servlet> allJersey2Servlets() {
        return this.restApiGroup.getComponents().stream().map(RestApi::getJersey2Servlet);
    }

    public void setMemoryPercentage(Integer memoryPercentage) {
        this.memoryPercentage = memoryPercentage;
    }

    public Optional<Integer> getMemoryPercentage() {
        return Optional.ofNullable(this.memoryPercentage);
    }

    @Override
    public void getConfig(BundlesConfig.Builder builder) {
        this.applicationBundles.stream().map(FileReference::value).forEach(arg_0 -> ((BundlesConfig.Builder)builder).bundle(arg_0));
        super.getConfig(builder);
    }

    public void getConfig(ServletPathsConfig.Builder builder) {
        this.allServlets().forEach(servlet -> builder.servlets(servlet.getComponentId().stringValue(), servlet.toConfigBuilder()));
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        if (this.modelEvaluation != null) {
            this.modelEvaluation.getConfig(builder);
        }
    }

    public void getConfig(RankingConstantsConfig.Builder builder) {
        if (this.modelEvaluation != null) {
            this.modelEvaluation.getConfig(builder);
        }
    }

    public void getConfig(ContainerMbusConfig.Builder builder) {
        if (this.mbusParams != null) {
            if (this.mbusParams.maxConcurrentFactor != null) {
                builder.maxConcurrentFactor(this.mbusParams.maxConcurrentFactor.doubleValue());
            }
            if (this.mbusParams.documentExpansionFactor != null) {
                builder.documentExpansionFactor(this.mbusParams.documentExpansionFactor.doubleValue());
            }
            if (this.mbusParams.containerCoreMemory != null) {
                builder.containerCoreMemory(this.mbusParams.containerCoreMemory.intValue());
            }
        }
        if (this.getDocproc() != null) {
            this.getDocproc().getConfig(builder);
        }
    }

    public void getConfig(MetricsProxyApiConfig.Builder builder) {
        builder.metricsPort(19092).metricsApiPath("/applicationmetrics/v1/values");
    }

    @Override
    public void getConfig(QrStartConfig.Builder builder) {
        super.getConfig(builder);
        builder.jvm.verbosegc(true).availableProcessors(0).compressedClassSpaceSize(0).minHeapsize(1536).heapsize(1536);
        if (this.getMemoryPercentage().isPresent()) {
            builder.jvm.heapSizeAsPercentageOfPhysicalMemory(this.getMemoryPercentage().get().intValue());
        } else if (this.isHostedVespa()) {
            builder.jvm.heapSizeAsPercentageOfPhysicalMemory(this.getHostClusterId().isPresent() ? 17 : 60);
        }
    }

    public Optional<String> getTlsClientAuthority() {
        return this.tlsClientAuthority;
    }

    public void setMbusParams(MbusParams mbusParams) {
        this.mbusParams = mbusParams;
    }

    public final void setMessageBusEnabled(boolean messageBusEnabled) {
        this.messageBusEnabled = messageBusEnabled;
    }

    @Override
    protected boolean messageBusEnabled() {
        return this.messageBusEnabled;
    }

    public void addMbusServer(ComponentId chainId) {
        ComponentId serviceId = chainId.nestInNamespace(ComponentId.fromString((String)"MbusServer"));
        this.addComponent(new Component(new ComponentModel(new BundleInstantiationSpecification(serviceId, ComponentSpecification.fromString((String)MbusServerProvider.class.getName()), null))));
    }

    public void getConfig(ThreadpoolConfig.Builder builder) {
        builder.softStartSeconds(this.softStartSeconds);
    }

    public static class MbusParams {
        final Double maxConcurrentFactor;
        final Double documentExpansionFactor;
        final Integer containerCoreMemory;

        public MbusParams(Double maxConcurrentFactor, Double documentExpansionFactor, Integer containerCoreMemory) {
            this.maxConcurrentFactor = maxConcurrentFactor;
            this.documentExpansionFactor = documentExpansionFactor;
            this.containerCoreMemory = containerCoreMemory;
        }
    }
}

