/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class AddExtraFieldsToDocument
extends Processor {
    AddExtraFieldsToDocument(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    private boolean dirtyLegalFieldNameCheck(String fieldName) {
        return !fieldName.contains(".") && !"rankfeatures".equals(fieldName) && !"summaryfeatures".equals(fieldName);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        SDDocumentType document = this.search.getDocument();
        if (document != null) {
            for (Field field : this.search.extraFieldList()) {
                this.addSdField(this.search, document, (SDField)field, validate);
            }
            for (SummaryField summaryField : this.search.getSummary("default").getSummaryFields()) {
                if (!this.dirtyLegalFieldNameCheck(summaryField.getName())) continue;
                this.addSummaryField(this.search, document, summaryField, validate);
            }
        }
    }

    private void addSdField(Search search, SDDocumentType document, SDField field, boolean validate) {
        if (!field.hasIndex() && field.getAttributes().isEmpty()) {
            return;
        }
        for (Attribute atr : field.getAttributes().values()) {
            if (atr.getName().equals(field.getName() + "_position")) {
                StructDataType type = PositionDataType.INSTANCE;
                if (atr.getCollectionType().equals((Object)Attribute.CollectionType.ARRAY)) {
                    type = DataType.getArray((DataType)type);
                }
                this.addField(search, document, new SDField(document, atr.getName(), (DataType)type), validate);
                continue;
            }
            if (atr.getName().equals(field.getName())) continue;
            this.addField(search, document, new SDField(document, atr.getName(), atr.getDataType()), validate);
        }
        this.addField(search, document, field, validate);
    }

    private void addSummaryField(Search search, SDDocumentType document, SummaryField field, boolean validate) {
        Field docField = document.getField(field.getName());
        if (docField == null) {
            ImmutableSDField existingField = search.getField(field.getName());
            if (existingField == null) {
                SDField newField = new SDField(document, field.getName(), field.getDataType(), true);
                newField.setIsExtraField(true);
                document.addField(newField);
            } else if (!existingField.isImportedField()) {
                document.addField(existingField.asField());
            }
        } else if (!docField.getDataType().equals((Object)field.getDataType()) && validate) {
            throw this.newProcessException(search, field, "Summary field has conflicting type.");
        }
    }

    private void addField(Search search, SDDocumentType document, Field field, boolean validate) {
        if (document.getField(field.getName()) != null && validate) {
            throw this.newProcessException(search, field, "Field shadows another.");
        }
        document.addField(field);
    }
}

