/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.NetworkPorts;
import com.yahoo.config.provision.ProvisionLogger;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.HostResource;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class HostSystem
extends AbstractConfigProducer<Host> {
    private static Logger log = Logger.getLogger(HostSystem.class.getName());
    private final Map<String, HostResource> hostname2host = new LinkedHashMap<String, HostResource>();
    private final HostProvisioner provisioner;
    private final DeployLogger deployLogger;

    public HostSystem(AbstractConfigProducer<?> parent, String name, HostProvisioner provisioner, DeployLogger deployLogger) {
        super(parent, name);
        this.provisioner = provisioner;
        this.deployLogger = deployLogger;
    }

    void checkName(String hostname) {
        try {
            InetAddress inetAddress = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            this.deployLogger.log(Level.WARNING, "Unable to lookup IP address of host: " + hostname);
        }
        if (!hostname.contains(".")) {
            this.deployLogger.log(Level.WARNING, "Host named '" + hostname + "' may not receive any config since it is not a canonical hostname. Disregard this warning when testing in a Docker container.");
        }
    }

    public HostResource getHostByHostname(String name) {
        if ("localhost.fortestingpurposesonly".equals(name)) {
            String localhost = "localhost";
            if (!this.getChildren().containsKey(localhost)) {
                new Host(this, localhost);
            }
            return new HostResource((Host)this.getChildren().get(localhost));
        }
        return this.hostname2host.get(name);
    }

    public String toString() {
        return "hosts [" + this.hostname2host.values().stream().map(HostResource::getHostname).collect(Collectors.joining(", ")) + "]";
    }

    public HostResource getHost(String hostAlias) {
        HostSpec hostSpec = this.provisioner.allocateHost(hostAlias);
        HostResource resource = this.hostname2host.get(hostSpec.hostname());
        return resource != null ? resource : this.addNewHost(hostSpec);
    }

    private HostResource addNewHost(HostSpec hostSpec) {
        Host host = Host.createHost(this, hostSpec.hostname());
        HostResource hostResource = new HostResource(host, hostSpec);
        hostSpec.networkPorts().ifPresent(np -> hostResource.ports().addNetworkPorts((NetworkPorts)np));
        this.hostname2host.put(host.getHostname(), hostResource);
        return hostResource;
    }

    public List<HostResource> getHosts() {
        return this.hostname2host.values().stream().filter(host -> !host.getHost().runsConfigServer()).collect(Collectors.toList());
    }

    public void dumpPortAllocations() {
        for (HostResource hr : this.getHosts()) {
            hr.ports().flushPortReservations();
        }
    }

    public Map<HostResource, ClusterMembership> allocateHosts(ClusterSpec cluster, Capacity capacity, int groups, DeployLogger logger) {
        List allocatedHosts = this.provisioner.prepare(cluster, capacity, groups, (ProvisionLogger)new ProvisionDeployLogger(logger));
        LinkedHashMap<HostResource, ClusterMembership> retAllocatedHosts = new LinkedHashMap<HostResource, ClusterMembership>();
        for (HostSpec spec : allocatedHosts) {
            HostResource host2 = this.getExistingHost(spec).orElseGet(() -> this.addNewHost(spec));
            retAllocatedHosts.put(host2, spec.membership().orElse(null));
        }
        retAllocatedHosts.keySet().forEach(host -> log.log((Level)LogLevel.DEBUG, () -> "Allocated host " + host.getHostname() + " with flavor " + host.getFlavor()));
        return retAllocatedHosts;
    }

    private Optional<HostResource> getExistingHost(HostSpec key) {
        List hosts = this.hostname2host.values().stream().filter(resource -> resource.getHostname().equals(key.hostname())).collect(Collectors.toList());
        if (hosts.isEmpty()) {
            return Optional.empty();
        }
        log.log((Level)LogLevel.DEBUG, () -> "Found existing host resource for " + key.hostname() + " with flavor " + ((HostResource)hosts.get(0)).getFlavor());
        return Optional.of((HostResource)hosts.get(0));
    }

    public void addBoundHost(HostResource host) {
        this.hostname2host.put(host.getHostname(), host);
    }

    Set<HostSpec> getHostSpecs() {
        return this.getHosts().stream().map(HostResource::spec).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static class ProvisionDeployLogger
    implements ProvisionLogger {
        private final DeployLogger deployLogger;

        public ProvisionDeployLogger(DeployLogger deployLogger) {
            this.deployLogger = deployLogger;
        }

        public void log(Level level, String message) {
            this.deployLogger.log(level, message);
        }
    }
}

