/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.Flavor;
import com.yahoo.config.provision.NetworkPorts;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.NetworkPortRequestor;
import com.yahoo.vespa.model.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class HostResource
implements Comparable<HostResource> {
    public static final int BASE_PORT = 19100;
    static final int MAX_PORTS = 799;
    private final Host host;
    private final Map<String, Service> services = new LinkedHashMap<String, Service>();
    private final Map<Integer, NetworkPortRequestor> portDB = new LinkedHashMap<Integer, NetworkPortRequestor>();
    private int allocatedPorts = 0;
    private List<PortReservation> portReservations = new ArrayList<PortReservation>();
    private Set<ClusterMembership> clusterMemberships = new LinkedHashSet<ClusterMembership>();
    private Optional<Flavor> flavor = Optional.empty();
    private final Optional<Version> version;
    private Optional<NetworkPorts> networkPortsList = Optional.empty();

    public Optional<NetworkPorts> networkPorts() {
        return this.networkPortsList;
    }

    public void addNetworkPorts(NetworkPorts ports) {
        this.networkPortsList = Optional.of(ports);
    }

    public HostResource(Host host) {
        this(host, Optional.empty());
    }

    public HostResource(Host host, Optional<Version> version) {
        this.host = host;
        this.version = version;
    }

    public Host getHost() {
        return this.host;
    }

    public Optional<Version> version() {
        return this.version;
    }

    public int nextAvailableBaseport(int numPorts) {
        int port;
        int range = 0;
        for (port = 19100; port < 19899 && range < numPorts; ++port) {
            if (this.portDB.containsKey(port)) {
                range = 0;
                continue;
            }
            ++range;
        }
        return range == numPorts ? port - range : 0;
    }

    List<Integer> allocateService(DeployLogger deployLogger, AbstractService service, int wantedPort) {
        List<Integer> ports = this.allocatePorts(deployLogger, service, wantedPort);
        assert (this.getService(service.getServiceName()) == null) : "There is already a service with name '" + service.getServiceName() + "' registered on " + this + ". Most likely a programming error - all service classes must have unique names, even in different packages!";
        this.services.put(service.getServiceName(), service);
        return ports;
    }

    private List<Integer> allocatePorts(DeployLogger deployLogger, NetworkPortRequestor service, int wantedPort) {
        String[] suffixes;
        ArrayList<Integer> ports = new ArrayList<Integer>();
        if (service.getPortCount() < 1) {
            return ports;
        }
        int serviceBasePort = 19100 + this.allocatedPorts;
        if (wantedPort > 0 && (service.requiresWantedPort() || this.canUseWantedPort(deployLogger, service, wantedPort, serviceBasePort))) {
            serviceBasePort = wantedPort;
        }
        if ((suffixes = service.getPortSuffixes()).length != service.getPortCount()) {
            throw new IllegalArgumentException("service " + service + " had " + suffixes.length + " port suffixes, but port count " + service.getPortCount() + ", mismatch");
        }
        this.reservePort(service, serviceBasePort, suffixes[0]);
        ports.add(serviceBasePort);
        int remainingPortsStart = service.requiresConsecutivePorts() ? serviceBasePort + 1 : 19100 + this.allocatedPorts;
        for (int i = 0; i < service.getPortCount() - 1; ++i) {
            int port = remainingPortsStart + i;
            this.reservePort(service, port, suffixes[i + 1]);
            ports.add(port);
        }
        if (suffixes.length != service.getPortCount()) {
            throw new IllegalArgumentException("service " + service + " had " + suffixes.length + " port suffixes, but port count " + service.getPortCount() + ", mismatch");
        }
        return ports;
    }

    public void flushPortReservations() {
        ArrayList<NetworkPorts.Allocation> list = new ArrayList<NetworkPorts.Allocation>();
        for (PortReservation pr : this.portReservations) {
            String servType = pr.service.getServiceType();
            String configId = pr.service.getConfigId();
            list.add(new NetworkPorts.Allocation(pr.gotPort, servType, configId, pr.suffix));
        }
        this.networkPortsList = Optional.of(new NetworkPorts(list));
    }

    private boolean canUseWantedPort(DeployLogger deployLogger, NetworkPortRequestor service, int wantedPort, int serviceBasePort) {
        for (int i = 0; i < service.getPortCount(); ++i) {
            int port = wantedPort + i;
            if (this.portDB.containsKey(port)) {
                NetworkPortRequestor s = this.portDB.get(port);
                deployLogger.log(Level.WARNING, service.getServiceName() + " cannot reserve port " + port + " on " + this + ": Already reserved for " + s.getServiceName() + ". Using default port range from " + serviceBasePort);
                return false;
            }
            if (!service.requiresConsecutivePorts()) break;
        }
        return true;
    }

    void reservePort(NetworkPortRequestor service, int port, String suffix) {
        if (this.portDB.containsKey(port)) {
            this.portAlreadyReserved(service, port);
        } else {
            if (this.inVespasPortRange(port)) {
                ++this.allocatedPorts;
                if (this.allocatedPorts > 799) {
                    this.noMoreAvailablePorts();
                }
            }
            this.portDB.put(port, service);
            this.portReservations.add(new PortReservation(port, service, suffix));
        }
    }

    private boolean inVespasPortRange(int port) {
        return port >= 19100 && port < 19899;
    }

    private void portAlreadyReserved(NetworkPortRequestor service, int port) {
        NetworkPortRequestor otherService = this.portDB.get(port);
        int nextAvailablePort = this.nextAvailableBaseport(service.getPortCount());
        if (nextAvailablePort == 0) {
            this.noMoreAvailablePorts();
        }
        String msg = service.getClass().equals(otherService.getClass()) && service.requiresWantedPort() ? "You must set port explicitly for all instances of this service type, except the first one. " : "";
        throw new RuntimeException(service.getServiceName() + " cannot reserve port " + port + " on " + this + ": Already reserved for " + otherService.getServiceName() + ". " + msg + "Next available port is: " + nextAvailablePort + " ports used: " + this.portDB);
    }

    private void noMoreAvailablePorts() {
        throw new RuntimeException("Too many ports are reserved in Vespa's port range (19100..19899) on " + this + ". Move one or more services to another host, or outside this port range.");
    }

    public Service getService(String sentinelName) {
        return this.services.get(sentinelName);
    }

    public List<Service> getServices() {
        return new ArrayList<Service>(this.services.values());
    }

    public HostInfo getHostInfo() {
        return new HostInfo(this.getHostname(), (Collection)this.services.values().stream().map(Service::getServiceInfo).collect(Collectors.toSet()));
    }

    public void setFlavor(Optional<Flavor> flavor) {
        this.flavor = flavor;
    }

    public Optional<Flavor> getFlavor() {
        return this.flavor;
    }

    public void addClusterMembership(@Nullable ClusterMembership clusterMembership) {
        if (clusterMembership != null) {
            this.clusterMemberships.add(clusterMembership);
        }
    }

    public Set<ClusterMembership> clusterMemberships() {
        return Collections.unmodifiableSet(this.clusterMemberships);
    }

    public Optional<ClusterMembership> primaryClusterMembership() {
        return this.clusterMemberships().stream().sorted(HostResource::compareClusters).findFirst();
    }

    private static int compareClusters(ClusterMembership cluster1, ClusterMembership cluster2) {
        return cluster2.cluster().type().compareTo((Enum)cluster1.cluster().type());
    }

    public String toString() {
        return "host '" + this.host.getHostname() + "'";
    }

    public String getHostname() {
        return this.host.getHostname();
    }

    public int hashCode() {
        return this.host.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HostResource)) {
            return false;
        }
        return ((HostResource)other).host.equals(this.host);
    }

    @Override
    public int compareTo(HostResource other) {
        return this.host.compareTo(other.host);
    }

    public int comparePrimarilyByIndexTo(HostResource other) {
        Optional<ClusterMembership> thisMembership = this.primaryClusterMembership();
        Optional<ClusterMembership> otherMembership = other.primaryClusterMembership();
        if (thisMembership.isPresent() && otherMembership.isPresent()) {
            return Integer.compare(thisMembership.get().index(), otherMembership.get().index());
        }
        return this.getHostname().compareTo(other.getHostname());
    }

    public static List<HostResource> pickHosts(List<HostResource> hostsSelectedByIndex, int count) {
        return hostsSelectedByIndex.subList(0, Math.min(count, hostsSelectedByIndex.size()));
    }

    public static List<HostResource> pickHosts(Collection<HostResource> hosts, int count, int targetHostsSelectedByIndex) {
        targetHostsSelectedByIndex = Math.min(Math.min(targetHostsSelectedByIndex, count), hosts.size());
        List<HostResource> hostsSortedByName = new ArrayList<HostResource>(hosts);
        Collections.sort(hostsSortedByName);
        List<HostResource> hostsSortedByIndex = new ArrayList<HostResource>(hosts);
        hostsSortedByIndex.sort((a, b) -> a.comparePrimarilyByIndexTo((HostResource)b));
        hostsSortedByName = hostsSortedByName.subList(0, Math.min(count - targetHostsSelectedByIndex, hostsSortedByName.size()));
        hostsSortedByIndex.removeAll(hostsSortedByName);
        hostsSortedByIndex = hostsSortedByIndex.subList(0, Math.min(targetHostsSelectedByIndex, hostsSortedByIndex.size()));
        ArrayList<HostResource> finalHosts = new ArrayList<HostResource>();
        finalHosts.addAll(hostsSortedByName);
        finalHosts.addAll(hostsSortedByIndex);
        return finalHosts;
    }

    static class PortReservation {
        int gotPort;
        NetworkPortRequestor service;
        String suffix;

        PortReservation(int port, NetworkPortRequestor svc, String suf) {
            this.gotPort = port;
            this.service = svc;
            this.suffix = suf;
        }
    }
}

