/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.collections.Pair;
import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ResourcesReductionValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel current, VespaModel next, ValidationOverrides overrides, Instant now) {
        Map<Pair<ClusterSpec.Type, ClusterSpec.Id>, NodeResources> currentRequestedResourcesByClusterId = ResourcesReductionValidator.getRequestedResourcesByClusterId(current);
        Map<Pair<ClusterSpec.Type, ClusterSpec.Id>, NodeResources> nextRequestedResourcesByClusterId = ResourcesReductionValidator.getRequestedResourcesByClusterId(next);
        for (Pair<ClusterSpec.Type, ClusterSpec.Id> clusterTypeAndId : currentRequestedResourcesByClusterId.keySet()) {
            if (!nextRequestedResourcesByClusterId.containsKey(clusterTypeAndId)) continue;
            this.validate(currentRequestedResourcesByClusterId.get(clusterTypeAndId), nextRequestedResourcesByClusterId.get(clusterTypeAndId), (ClusterSpec.Id)clusterTypeAndId.getSecond(), overrides, now);
        }
        return List.of();
    }

    private void validate(NodeResources currentResources, NodeResources nextResources, ClusterSpec.Id clusterId, ValidationOverrides overrides, Instant now) {
        List illegalChanges = Stream.of(ResourcesReductionValidator.validateResource("vCPU", currentResources.vcpu(), nextResources.vcpu()), ResourcesReductionValidator.validateResource("memory GB", currentResources.memoryGb(), nextResources.memoryGb()), ResourcesReductionValidator.validateResource("disk GB", currentResources.diskGb(), nextResources.diskGb())).flatMap(Optional::stream).collect(Collectors.toList());
        if (illegalChanges.isEmpty()) {
            return;
        }
        overrides.invalid(ValidationId.resourcesReduction, "Resource reduction in '" + clusterId.value() + "' is too large. " + String.join((CharSequence)" ", illegalChanges) + " New resources must be at least 50% of the current resources", now);
    }

    private static Optional<String> validateResource(String resourceName, double currentValue, double nextValue) {
        if (nextValue >= currentValue * 0.5 || nextValue >= currentValue - 1.0) {
            return Optional.empty();
        }
        return Optional.of(String.format(Locale.ENGLISH, "Current %s: %.2f, new: %.2f.", resourceName, currentValue, nextValue));
    }

    private static Map<Pair<ClusterSpec.Type, ClusterSpec.Id>, NodeResources> getRequestedResourcesByClusterId(VespaModel vespaModel) {
        return vespaModel.hostSystem().getHosts().stream().map(HostResource::spec).filter(spec -> spec.membership().isPresent() && spec.requestedResources().isPresent()).filter(spec -> !((ClusterMembership)spec.membership().get()).retired()).collect(Collectors.toMap(spec -> new Pair((Object)((ClusterMembership)spec.membership().get()).cluster().type(), (Object)((ClusterMembership)spec.membership().get()).cluster().id()), spec -> (NodeResources)spec.requestedResources().get(), (e1, e2) -> e1));
    }
}

