/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModel;
import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModels;
import com.yahoo.collections.Pair;
import com.yahoo.component.Version;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.codegen.ConfiggenUtil;
import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.ConfigModelRegistry;
import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.config.model.NullConfigModelRegistry;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.model.producer.UserConfigRepo;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.log.LogLevel;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.RankingConstants;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.RankProfileList;
import com.yahoo.searchdefinition.processing.Processing;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.ConfigPayloadBuilder;
import com.yahoo.vespa.config.GenericConfig;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.model.ConfigProducer;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.InstanceResolver;
import com.yahoo.vespa.model.VespaConfigModelRegistry;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.builder.VespaModelBuilder;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.clients.Clients;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.vespa.model.content.Content;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProducer;
import com.yahoo.vespa.model.filedistribution.FileDistributor;
import com.yahoo.vespa.model.generic.service.ServiceCluster;
import com.yahoo.vespa.model.ml.ConvertedModel;
import com.yahoo.vespa.model.ml.ModelName;
import com.yahoo.vespa.model.routing.Routing;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.utils.internal.ReflectionUtil;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.xml.sax.SAXException;

public final class VespaModel
extends AbstractConfigProducerRoot
implements Serializable,
Model {
    private static final long serialVersionUID = 1L;
    public static final Logger log = Logger.getLogger(VespaModel.class.getPackage().toString());
    private final Version version;
    private final ConfigModelRepo configModelRepo = new ConfigModelRepo();
    private final AllocatedHosts allocatedHosts;
    public static final String ROOT_CONFIGID = "";
    private final ApplicationConfigProducerRoot root;
    private final ApplicationPackage applicationPackage;
    private final List<ServiceCluster> serviceClusters = new ArrayList<ServiceCluster>();
    private final RankProfileList rankProfileList;
    private final RankingConstants rankingConstants = new RankingConstants();
    private final ValidationOverrides validationOverrides;
    private final FileDistributor fileDistributor;

    public VespaModel(ApplicationPackage app) throws IOException, SAXException {
        this(app, new NullConfigModelRegistry());
    }

    public VespaModel(DeployState deployState) throws IOException, SAXException {
        this(new NullConfigModelRegistry(), deployState);
    }

    public VespaModel(ApplicationPackage app, ConfigModelRegistry configModelRegistry) throws IOException, SAXException {
        this(configModelRegistry, new DeployState.Builder().applicationPackage(app).build());
    }

    public VespaModel(ConfigModelRegistry configModelRegistry, DeployState deployState) throws IOException, SAXException {
        this(configModelRegistry, deployState, true, null);
    }

    private VespaModel(ConfigModelRegistry configModelRegistry, DeployState deployState, boolean complete, FileDistributor fileDistributor) throws IOException, SAXException {
        super("vespamodel");
        this.version = deployState.getVespaVersion();
        this.validationOverrides = deployState.validationOverrides();
        configModelRegistry = new VespaConfigModelRegistry(configModelRegistry);
        VespaDomBuilder builder = new VespaDomBuilder();
        this.applicationPackage = deployState.getApplicationPackage();
        this.root = ((VespaModelBuilder)builder).getRoot(ROOT_CONFIGID, deployState, this);
        this.createGlobalRankProfiles(deployState.getDeployLogger(), deployState.getImportedModels(), deployState.rankProfileRegistry(), deployState.getQueryProfiles());
        this.rankProfileList = new RankProfileList(null, this.rankingConstants, AttributeFields.empty, deployState.rankProfileRegistry(), deployState.getQueryProfiles().getRegistry(), deployState.getImportedModels(), deployState.getProperties());
        HostSystem hostSystem = this.root.hostSystem();
        if (complete) {
            this.configModelRepo.readConfigModels(deployState, this, builder, this.root, configModelRegistry);
            this.addServiceClusters(deployState, builder);
            this.setupRouting(deployState);
            this.fileDistributor = this.root.getFileDistributionConfigProducer().getFileDistributor();
            this.getAdmin().addPerHostServices(hostSystem.getHosts(), deployState);
            this.freezeModelTopology();
            this.root.prepare(this.configModelRepo);
            this.configModelRepo.prepareConfigModels(deployState);
            this.validateWrapExceptions();
            hostSystem.dumpPortAllocations();
            this.allocatedHosts = AllocatedHosts.withHosts(hostSystem.getHostSpecs());
        } else {
            this.allocatedHosts = AllocatedHosts.withHosts(hostSystem.getHostSpecs());
            this.fileDistributor = fileDistributor;
        }
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public RankingConstants rankingConstants() {
        return this.rankingConstants;
    }

    public static VespaModel createIncomplete(DeployState deployState) throws IOException, SAXException {
        return new VespaModel(new NullConfigModelRegistry(), deployState, false, new FileDistributor(deployState.getFileRegistry(), null));
    }

    private void validateWrapExceptions() {
        try {
            this.validate();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while validating model:", e);
        }
    }

    private void addServiceClusters(DeployState deployState, VespaModelBuilder builder) {
        this.serviceClusters.addAll(builder.getClusters(deployState, this));
    }

    private void createGlobalRankProfiles(DeployLogger deployLogger, ImportedMlModels importedModels, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        if (!importedModels.all().isEmpty()) {
            for (ImportedMlModel model : importedModels.all()) {
                RankProfile profile = new RankProfile(model.name(), this, rankProfileRegistry);
                rankProfileRegistry.add(profile);
                ConvertedModel convertedModel = ConvertedModel.fromSource(new ModelName(model.name()), model.name(), profile, queryProfiles.getRegistry(), model);
                convertedModel.expressions().values().forEach(f -> profile.addFunction((ExpressionFunction)f, false));
            }
        } else {
            ApplicationFile generatedModelsDir = this.applicationPackage.getFile(ApplicationPackage.MODELS_GENERATED_REPLICATED_DIR);
            for (ApplicationFile generatedModelDir : generatedModelsDir.listFiles()) {
                String modelName = generatedModelDir.getPath().last();
                if (modelName.contains(".")) continue;
                RankProfile profile = new RankProfile(modelName, this, rankProfileRegistry);
                rankProfileRegistry.add(profile);
                ConvertedModel convertedModel = ConvertedModel.fromStore(new ModelName(modelName), modelName, profile);
                convertedModel.expressions().values().forEach(f -> profile.addFunction((ExpressionFunction)f, false));
            }
        }
        new Processing().processRankProfiles(deployLogger, rankProfileRegistry, queryProfiles, true, false);
    }

    public RankProfileList rankProfileList() {
        return this.rankProfileList;
    }

    private void setupRouting(DeployState deployState) {
        this.root.setupRouting(deployState, this, this.configModelRepo);
    }

    @Override
    public HostSystem hostSystem() {
        return this.root.hostSystem();
    }

    public Set<HostInfo> getHosts() {
        return this.hostSystem().getHosts().stream().map(HostResource::getHostInfo).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public FileDistributor getFileDistributor() {
        return this.fileDistributor;
    }

    public Set<FileReference> fileReferences() {
        return this.fileDistributor.allFilesToSend();
    }

    public ApplicationConfigProducerRoot getVespa() {
        return this.root;
    }

    public boolean allowModelVersionMismatch(Instant now) {
        return this.validationOverrides.allows(ValidationId.configModelVersionMismatch, now) || this.validationOverrides.allows(ValidationId.skipOldConfigModels, now);
    }

    public boolean skipOldConfigModels(Instant now) {
        return this.validationOverrides.allows(ValidationId.skipOldConfigModels, now);
    }

    public Version version() {
        return this.version;
    }

    @Override
    public <CONFIGTYPE extends ConfigInstance> CONFIGTYPE getConfig(Class<CONFIGTYPE> clazz, String configId) {
        try {
            ConfigInstance.Builder builder = VespaModel.newBuilder(clazz);
            this.getConfig(builder, configId);
            return VespaModel.newConfigInstance(clazz, builder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <CONFIGTYPE extends ConfigInstance> CONFIGTYPE getConfig(Class<CONFIGTYPE> configClass, ConfigProducer configProducer) {
        try {
            ConfigInstance.Builder builder = VespaModel.newBuilder(configClass);
            VespaModel.populateConfigBuilder(builder, configProducer);
            return VespaModel.newConfigInstance(configClass, builder);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed getting config for class " + configClass.getName(), e);
        }
    }

    private static <CONFIGTYPE extends ConfigInstance> CONFIGTYPE newConfigInstance(Class<CONFIGTYPE> configClass, ConfigInstance.Builder builder) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<CONFIGTYPE> constructor = configClass.getConstructor(builder.getClass());
        return (CONFIGTYPE)((ConfigInstance)constructor.newInstance(builder));
    }

    private static ConfigInstance.Builder newBuilder(Class<? extends ConfigInstance> configClass) throws ReflectiveOperationException {
        Class<?> builderClazz = configClass.getClassLoader().loadClass(configClass.getName() + "$Builder");
        return (ConfigInstance.Builder)builderClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected void checkId(String configId) {
        if (!this.id2producer.containsKey(configId)) {
            log.log((Level)LogLevel.DEBUG, "Invalid config id: " + configId);
        }
    }

    @Override
    public ConfigInstance.Builder getConfig(ConfigInstance.Builder builder, String configId) {
        this.checkId(configId);
        Optional<ConfigProducer> configProducer = this.getConfigProducer(configId);
        if (configProducer.isEmpty()) {
            return null;
        }
        VespaModel.populateConfigBuilder(builder, configProducer.get());
        return builder;
    }

    private static void populateConfigBuilder(ConfigInstance.Builder builder, ConfigProducer configProducer) {
        boolean found = configProducer.cascadeConfig(builder);
        boolean foundOverride = configProducer.addUserConfig(builder);
        log.log((Level)LogLevel.DEBUG, () -> "Trying to get config for " + builder.getClass().getDeclaringClass().getName() + " for config id " + StringUtilities.quote((Object)configProducer.getConfigId()) + ", found=" + found + ", foundOverride=" + foundOverride);
    }

    public ConfigPayload getConfig(ConfigKey configKey, ConfigDefinition targetDef) {
        ConfigInstance.Builder builder = this.resolveToBuilder(configKey);
        if (builder != null) {
            log.log((Level)LogLevel.DEBUG, () -> "Found builder for " + configKey);
            InnerCNode innerCNode = targetDef != null ? targetDef.getCNode() : null;
            ConfigPayload payload = builder instanceof GenericConfig.GenericConfigBuilder ? this.getConfigFromGenericBuilder((ConfigBuilder)builder) : this.getConfigFromBuilder(builder, innerCNode);
            return innerCNode != null ? payload.applyDefaultsFromDef(innerCNode) : payload;
        }
        return null;
    }

    private ConfigInstance.Builder resolveToBuilder(ConfigKey<?> key) {
        ConfigDefinitionKey defKey = new ConfigDefinitionKey(key);
        ConfigInstance.Builder builder = this.createBuilder(defKey);
        this.getConfig(builder, key.getConfigId());
        return builder;
    }

    private ConfigPayload getConfigFromBuilder(ConfigInstance.Builder builder, InnerCNode targetDef) {
        try {
            ConfigInstance instance = InstanceResolver.resolveToInstance(builder, targetDef);
            log.log((Level)LogLevel.DEBUG, () -> "getConfigFromBuilder for builder " + builder.getClass().getName() + ", instance=" + instance);
            return ConfigPayload.fromInstance((ConfigInstance)instance);
        }
        catch (ConfigurationRuntimeException e) {
            log.log(LogLevel.INFO, "Error resolving instance for builder '" + builder.getClass().getName() + "', returning empty config: " + Exceptions.toMessageString((Throwable)e));
            return ConfigPayload.fromBuilder((ConfigPayloadBuilder)new ConfigPayloadBuilder());
        }
    }

    private ConfigPayload getConfigFromGenericBuilder(ConfigBuilder builder) {
        return ((GenericConfig.GenericConfigBuilder)builder).getPayload();
    }

    public Set<ConfigKey<?>> allConfigsProduced() {
        LinkedHashSet keySet = new LinkedHashSet();
        for (ConfigProducer producer : this.id2producer().values()) {
            keySet.addAll(VespaModel.configsProduced(producer));
        }
        return keySet;
    }

    private ConfigInstance.Builder createBuilder(ConfigDefinitionKey key) {
        Object i;
        Class<?> clazz;
        String className = ConfiggenUtil.createClassName((String)key.getName());
        Pair<String, ClassLoader> fullClassNameAndLoader = this.getClassLoaderForProducer(key, className);
        String fullClassName = (String)fullClassNameAndLoader.getFirst();
        ClassLoader classLoader = (ClassLoader)fullClassNameAndLoader.getSecond();
        String builderName = fullClassName + "$Builder";
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
            log.log((Level)LogLevel.DEBUG, () -> "No producer found to get classloader from for " + fullClassName + ". Using default");
        }
        try {
            clazz = classLoader.loadClass(builderName);
        }
        catch (ClassNotFoundException e) {
            log.log((Level)LogLevel.DEBUG, () -> "Tried to load " + builderName + ", not found, trying with generic builder");
            return new GenericConfig.GenericConfigBuilder(key, new ConfigPayloadBuilder());
        }
        try {
            i = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ConfigurationRuntimeException((Throwable)e);
        }
        if (!(i instanceof ConfigInstance.Builder)) {
            throw new ConfigurationRuntimeException(fullClassName + " is not a ConfigInstance.Builder, can not produce config for the name '" + key.getName() + "'.");
        }
        return (ConfigInstance.Builder)i;
    }

    private Pair<String, ClassLoader> getClassLoaderForProducer(ConfigDefinitionKey key, String shortClassName) {
        String producerSuffix;
        String fullClassNameWithComYahoo = InstanceResolver.packageName(key, InstanceResolver.PackagePrefix.COM_YAHOO) + "." + shortClassName;
        String fullClassNameWithoutPrefix = InstanceResolver.packageName(key, InstanceResolver.PackagePrefix.NONE) + "." + shortClassName;
        ClassLoader loader = this.getConfigClassLoader(fullClassNameWithoutPrefix + (producerSuffix = "$Producer"));
        if (loader != null) {
            return new Pair((Object)fullClassNameWithoutPrefix, (Object)loader);
        }
        return new Pair((Object)fullClassNameWithComYahoo, (Object)this.getConfigClassLoader(fullClassNameWithComYahoo + producerSuffix));
    }

    public Set<String> allConfigIds() {
        return this.id2producer.keySet();
    }

    public void distributeFiles(FileDistribution fileDistribution) {
        this.getFileDistributor().sendDeployedFiles(fileDistribution);
    }

    public AllocatedHosts allocatedHosts() {
        return this.allocatedHosts;
    }

    private static Set<ConfigKey<?>> configsProduced(ConfigProducer cp) {
        Set<ConfigKey<?>> ret = ReflectionUtil.getAllConfigsProduced(cp.getClass(), cp.getConfigId());
        UserConfigRepo userConfigs = cp.getUserConfigs();
        for (ConfigDefinitionKey userKey : userConfigs.configsProduced()) {
            ret.add(new ConfigKey(userKey.getName(), cp.getConfigId(), userKey.getNamespace()));
        }
        return ret;
    }

    @Override
    public Set<String> getConfigIds() {
        return Collections.unmodifiableSet(this.id2producer.keySet());
    }

    @Override
    public Admin getAdmin() {
        return this.root.getAdmin();
    }

    @Override
    public void addDescendant(String configId, AbstractConfigProducer descendant) {
        if (this.id2producer.containsKey(configId)) {
            throw new RuntimeException("Config ID '" + configId + "' cannot be reserved by an instance of class '" + descendant.getClass().getName() + "' since it is already used by an instance of class '" + ((ConfigProducer)this.id2producer.get(configId)).getClass().getName() + "'. (This is commonly caused by service/node index collisions in the config.)");
        }
        this.id2producer.put(configId, descendant);
    }

    @Override
    public void writeFiles(File baseDirectory) throws IOException {
        super.writeFiles(baseDirectory);
        for (ConfigProducer cp : this.id2producer.values()) {
            try {
                File destination = new File(baseDirectory, cp.getConfigId().replace("/", File.separator));
                cp.writeFiles(destination);
            }
            catch (IOException e) {
                throw new IOException(cp.getConfigId() + ": " + e.getMessage());
            }
        }
    }

    public Clients getClients() {
        return this.configModelRepo.getClients();
    }

    public List<AbstractSearchCluster> getSearchClusters() {
        return Content.getSearchClusters(this.configModelRepo());
    }

    public Map<String, ContentCluster> getContentClusters() {
        LinkedHashMap<String, ContentCluster> clusters = new LinkedHashMap<String, ContentCluster>();
        for (Content model : this.configModelRepo.getModels(Content.class)) {
            clusters.put(model.getId(), model.getCluster());
        }
        return Collections.unmodifiableMap(clusters);
    }

    public Map<String, ApplicationContainerCluster> getContainerClusters() {
        LinkedHashMap<String, ApplicationContainerCluster> clusters = new LinkedHashMap<String, ApplicationContainerCluster>();
        for (ContainerModel model : this.configModelRepo.getModels(ContainerModel.class)) {
            if (!(model.getCluster() instanceof ApplicationContainerCluster)) continue;
            clusters.put(model.getId(), (ApplicationContainerCluster)model.getCluster());
        }
        return Collections.unmodifiableMap(clusters);
    }

    public Routing getRouting() {
        return this.configModelRepo.getRouting();
    }

    @Override
    public FileDistributionConfigProducer getFileDistributionConfigProducer() {
        return this.root.getFileDistributionConfigProducer();
    }

    public List<ServiceCluster> serviceClusters() {
        return this.serviceClusters;
    }

    public Map<String, ConfigProducer> id2producer() {
        return Collections.unmodifiableMap(this.id2producer);
    }

    @Override
    public ConfigModelRepo configModelRepo() {
        return this.configModelRepo;
    }
}

