/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.monitoring;

import com.yahoo.vespa.model.admin.monitoring.Metric;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MetricSet {
    private final String id;
    private final Map<String, Metric> metrics;
    private final Set<MetricSet> children;

    public MetricSet(String id, Collection<Metric> metrics, Collection<MetricSet> children) {
        Objects.requireNonNull(id, "Id cannot be null or empty.");
        this.id = id;
        this.metrics = this.toMapByName(metrics);
        this.children = new LinkedHashSet<MetricSet>(children);
    }

    public MetricSet(String id, Collection<Metric> metrics) {
        this(id, metrics, Collections.emptySet());
    }

    public static MetricSet emptyMetricSet() {
        return new MetricSet("empty", Collections.emptySet());
    }

    public final String getId() {
        return this.id;
    }

    public final Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.flatten(this.metrics, this.children));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricSet)) {
            return false;
        }
        MetricSet that = (MetricSet)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    private Map<String, Metric> flatten(Map<String, Metric> metrics, Set<MetricSet> children) {
        LinkedHashMap<String, Metric> joinedMetrics = new LinkedHashMap<String, Metric>(metrics);
        for (MetricSet child : children) {
            child.getMetrics().forEach((name, metric) -> {
                if (joinedMetrics.containsKey(name)) {
                    joinedMetrics.put((String)name, ((Metric)joinedMetrics.get(name)).addDimensionsFrom((Metric)metric));
                } else {
                    joinedMetrics.put((String)name, (Metric)metric);
                }
            });
        }
        return joinedMetrics;
    }

    private Map<String, Metric> toMapByName(Collection<Metric> metrics) {
        LinkedHashMap<String, Metric> metricMap = new LinkedHashMap<String, Metric>();
        metrics.forEach(metric -> metricMap.put(metric.name, (Metric)metric));
        return metricMap;
    }
}

