/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.metricsproxy;

import ai.vespa.metricsproxy.metric.dimensions.NodeDimensions;
import ai.vespa.metricsproxy.metric.dimensions.NodeDimensionsConfig;
import ai.vespa.metricsproxy.rpc.RpcConnector;
import ai.vespa.metricsproxy.rpc.RpcConnectorConfig;
import ai.vespa.metricsproxy.service.VespaServices;
import ai.vespa.metricsproxy.service.VespaServicesConfig;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.vespa.model.PortAllocBridge;
import com.yahoo.vespa.model.admin.metricsproxy.VespaServicesConfigGenerator;
import com.yahoo.vespa.model.container.Container;
import java.util.LinkedHashMap;

public class MetricsProxyContainer
extends Container
implements NodeDimensionsConfig.Producer,
RpcConnectorConfig.Producer,
VespaServicesConfig.Producer {
    final boolean isHostedVespa;
    public static int BASEPORT = 19092;
    private int metricsRpcPort;

    public MetricsProxyContainer(AbstractConfigProducer parent, String hostname, int index, boolean isHostedVespa) {
        super(parent, hostname, index);
        this.isHostedVespa = isHostedVespa;
        this.setProp("clustertype", "admin");
        this.setProp("index", String.valueOf(index));
        this.addNodeSpecificComponents();
    }

    private void addNodeSpecificComponents() {
        this.addMetricsProxyComponent(NodeDimensions.class);
        this.addMetricsProxyComponent(RpcConnector.class);
        this.addMetricsProxyComponent(VespaServices.class);
    }

    @Override
    protected ContainerServiceType myServiceType() {
        return ContainerServiceType.METRICS_PROXY_CONTAINER;
    }

    @Override
    public int getWantedPort() {
        return BASEPORT;
    }

    @Override
    public boolean requiresWantedPort() {
        return true;
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
        if (start == 0) {
            start = BASEPORT;
        }
        if (this.getHttp() != null) {
            throw new IllegalArgumentException("unexpected HTTP setup");
        }
        this.allocatedSearchPort = from.wantPort(start++, "http");
        this.portsMeta.on(0).tag("http").tag("query").tag("external").tag("state");
        from.wantPort(start++, "http/1");
        this.portsMeta.on(1).tag("unused");
        if (this.numMessageBusPorts() != 0) {
            throw new IllegalArgumentException("expecting 0 message bus ports");
        }
        if (this.numRpcPorts() != 1) {
            throw new IllegalArgumentException("expecting 1 rpc port");
        }
        this.allocatedRpcPort = from.wantPort(start++, "rpc/admin");
        this.portsMeta.on(2).tag("rpc").tag("admin");
        this.metricsRpcPort = from.wantPort(start++, "rpc/metrics");
        this.portsMeta.on(3).tag("rpc").tag("metrics");
    }

    @Override
    public int getPortCount() {
        return 4;
    }

    public void getConfig(RpcConnectorConfig.Builder builder) {
        builder.port(this.metricsRpcPort);
    }

    public void getConfig(VespaServicesConfig.Builder builder) {
        builder.service.addAll(VespaServicesConfigGenerator.generate(this.getHostResource().getServices()));
    }

    public void getConfig(NodeDimensionsConfig.Builder builder) {
        LinkedHashMap dimensions = new LinkedHashMap();
        if (this.isHostedVespa) {
            this.getHostResource().spec().membership().map(ClusterMembership::cluster).ifPresent(cluster -> {
                dimensions.put("clustertype", cluster.type().name());
                dimensions.put("clusterid", cluster.id().value());
            });
            builder.dimensions(dimensions);
        }
    }

    private void addMetricsProxyComponent(Class<?> componentClass) {
        this.addSimpleComponent(componentClass.getName(), null, "com.yahoo.vespa.metrics-proxy");
    }

    static final class NodeDimensionNames {
        static final String CLUSTER_TYPE = "clustertype";
        static final String CLUSTER_ID = "clusterid";

        NodeDimensionNames() {
        }
    }
}

