/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.document;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ImmutableSDField;

public class ComplexAttributeFieldUtils {
    public static boolean isSupportedComplexField(ImmutableSDField field) {
        return ComplexAttributeFieldUtils.isArrayOfSimpleStruct(field) || ComplexAttributeFieldUtils.isMapOfSimpleStruct(field) || ComplexAttributeFieldUtils.isMapOfPrimitiveType(field);
    }

    public static boolean isArrayOfSimpleStruct(ImmutableSDField field) {
        if (field.getDataType() instanceof ArrayDataType) {
            ArrayDataType arrayType = (ArrayDataType)field.getDataType();
            return ComplexAttributeFieldUtils.isStructWithPrimitiveStructFieldAttributes(arrayType.getNestedType(), field);
        }
        return false;
    }

    public static boolean isMapOfSimpleStruct(ImmutableSDField field) {
        if (field.getDataType() instanceof MapDataType) {
            MapDataType mapType = (MapDataType)field.getDataType();
            return ComplexAttributeFieldUtils.isPrimitiveType(mapType.getKeyType()) && ComplexAttributeFieldUtils.isStructWithPrimitiveStructFieldAttributes(mapType.getValueType(), field.getStructField("value"));
        }
        return false;
    }

    public static boolean isMapOfPrimitiveType(ImmutableSDField field) {
        if (field.getDataType() instanceof MapDataType) {
            MapDataType mapType = (MapDataType)field.getDataType();
            return ComplexAttributeFieldUtils.isPrimitiveType(mapType.getKeyType()) && ComplexAttributeFieldUtils.isPrimitiveType(mapType.getValueType());
        }
        return false;
    }

    private static boolean isStructWithPrimitiveStructFieldAttributes(DataType type, ImmutableSDField field) {
        if (type instanceof StructDataType && !type.equals((Object)PositionDataType.INSTANCE)) {
            for (ImmutableSDField immutableSDField : field.getStructFields()) {
                Attribute attribute = immutableSDField.getAttributes().get(immutableSDField.getName());
                if (attribute == null || ComplexAttributeFieldUtils.isPrimitiveType(attribute)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isPrimitiveType(Attribute attribute) {
        return attribute.getCollectionType().equals((Object)Attribute.CollectionType.SINGLE) && ComplexAttributeFieldUtils.isPrimitiveType(attribute.getDataType());
    }

    public static boolean isPrimitiveType(DataType dataType) {
        return dataType.equals((Object)DataType.BYTE) || dataType.equals((Object)DataType.INT) || dataType.equals((Object)DataType.LONG) || dataType.equals((Object)DataType.FLOAT) || dataType.equals((Object)DataType.DOUBLE) || dataType.equals((Object)DataType.STRING);
    }

    public static boolean isComplexFieldWithOnlyStructFieldAttributes(ImmutableSDField field) {
        if (ComplexAttributeFieldUtils.isArrayOfSimpleStruct(field)) {
            return ComplexAttributeFieldUtils.hasOnlyStructFieldAttributes(field);
        }
        if (ComplexAttributeFieldUtils.isMapOfSimpleStruct(field)) {
            return ComplexAttributeFieldUtils.hasSingleAttribute(field.getStructField("key")) && ComplexAttributeFieldUtils.hasOnlyStructFieldAttributes(field.getStructField("value"));
        }
        if (ComplexAttributeFieldUtils.isMapOfPrimitiveType(field)) {
            return ComplexAttributeFieldUtils.hasSingleAttribute(field.getStructField("key")) && ComplexAttributeFieldUtils.hasSingleAttribute(field.getStructField("value"));
        }
        return false;
    }

    private static boolean hasOnlyStructFieldAttributes(ImmutableSDField field) {
        for (ImmutableSDField immutableSDField : field.getStructFields()) {
            if (ComplexAttributeFieldUtils.hasSingleAttribute(immutableSDField)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSingleAttribute(ImmutableSDField field) {
        if (field.getAttributes().size() != 1) {
            return false;
        }
        return field.getAttributes().get(field.getName()) != null;
    }
}

