/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.searchdefinition.DocumentOnlySearch;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.DerivedConfiguration;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.DispatchConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.model.container.docproc.DocprocChain;
import com.yahoo.vespa.model.content.DispatchSpec;
import com.yahoo.vespa.model.content.SearchCoverage;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.search.DispatchGroup;
import com.yahoo.vespa.model.search.DispatchGroupBuilder;
import com.yahoo.vespa.model.search.DocumentDatabase;
import com.yahoo.vespa.model.search.DocumentSelectionConverter;
import com.yahoo.vespa.model.search.SearchCluster;
import com.yahoo.vespa.model.search.SearchNode;
import com.yahoo.vespa.model.search.Tuning;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IndexedSearchCluster
extends SearchCluster
implements DocumentdbInfoConfig.Producer,
IndexInfoConfig.Producer,
IlscriptsConfig.Producer,
DispatchConfig.Producer {
    private String indexingClusterName = null;
    private String indexingChainName = null;
    private DocprocChain indexingChain;
    private Tuning tuning;
    private SearchCoverage searchCoverage;
    private String routingSelector = null;
    private List<DocumentDatabase> documentDbs = new LinkedList<DocumentDatabase>();
    private final UnionConfiguration unionCfg;
    private int maxNodesDownPerFixedRow = 0;
    private int searchableCopies = 1;
    private final DispatchGroup rootDispatch;
    private DispatchSpec dispatchSpec;
    private final boolean useAdaptiveDispatch;
    private List<SearchNode> searchNodes = new ArrayList<SearchNode>();

    public String getRoutingSelector() {
        return this.routingSelector;
    }

    public IndexedSearchCluster(AbstractConfigProducer parent, String clusterName, int index, DeployState deployState) {
        super(parent, clusterName, index);
        this.unionCfg = new UnionConfiguration((AbstractConfigProducer)this, this.documentDbs);
        this.rootDispatch = new DispatchGroup(this);
        this.useAdaptiveDispatch = deployState.getProperties().useAdaptiveDispatch();
    }

    @Override
    protected AbstractSearchCluster.IndexingMode getIndexingMode() {
        return AbstractSearchCluster.IndexingMode.REALTIME;
    }

    public final boolean hasExplicitIndexingCluster() {
        return this.indexingClusterName != null;
    }

    public final boolean hasExplicitIndexingChain() {
        return this.indexingChainName != null;
    }

    public String getIndexingClusterName() {
        return this.hasExplicitIndexingCluster() ? this.indexingClusterName : this.getClusterName() + ".indexing";
    }

    public String getIndexingChainName() {
        return this.indexingChainName;
    }

    public void setIndexingChainName(String indexingChainName) {
        this.indexingChainName = indexingChainName;
    }

    public void setIndexingClusterName(String name) {
        this.indexingClusterName = name;
    }

    public String getIndexingServiceName() {
        return this.indexingChain.getServiceName();
    }

    public AbstractSearchCluster setIndexingChain(DocprocChain chain) {
        this.indexingChain = chain;
        return this;
    }

    public DispatchGroup getRootDispatch() {
        return this.rootDispatch;
    }

    public void addSearcher(SearchNode searcher) {
        this.searchNodes.add(searcher);
        this.rootDispatch.addSearcher(searcher);
    }

    public List<SearchNode> getSearchNodes() {
        return Collections.unmodifiableList(this.searchNodes);
    }

    public int getSearchNodeCount() {
        return this.searchNodes.size();
    }

    public SearchNode getSearchNode(int index) {
        return this.searchNodes.get(index);
    }

    public void setTuning(Tuning tuning) {
        this.tuning = tuning;
    }

    public Tuning getTuning() {
        return this.tuning;
    }

    public void fillDocumentDBConfig(String documentType, ProtonConfig.Documentdb.Builder builder) {
        for (DocumentDatabase sdoc : this.documentDbs) {
            if (!sdoc.getName().equals(documentType)) continue;
            this.fillDocumentDBConfig(sdoc, builder);
            return;
        }
    }

    private void fillDocumentDBConfig(DocumentDatabase sdoc, ProtonConfig.Documentdb.Builder ddbB) {
        ddbB.inputdoctypename(sdoc.getInputDocType()).configid(sdoc.getConfigId()).visibilitydelay(this.getVisibilityDelay().doubleValue());
    }

    @Override
    public void getConfig(DocumentdbInfoConfig.Builder builder) {
        for (DocumentDatabase db : this.documentDbs) {
            DocumentdbInfoConfig.Documentdb.Builder docDb = new DocumentdbInfoConfig.Documentdb.Builder();
            docDb.name(db.getName());
            this.convertSummaryConfig(db, db, docDb);
            RankProfilesConfig.Builder rpb = new RankProfilesConfig.Builder();
            db.getConfig(rpb);
            this.addRankProfilesConfig(docDb, new RankProfilesConfig(rpb));
            builder.documentdb(docDb);
        }
    }

    public void setRoutingSelector(String sel) {
        this.routingSelector = sel;
        if (this.routingSelector != null) {
            try {
                new DocumentSelectionConverter(this.routingSelector);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid routing selector: " + e.getMessage());
            }
        }
    }

    @Override
    public void defaultDocumentsConfig() {
        if (this.routingSelector == null && !this.getDocumentNames().isEmpty()) {
            Iterator<String> it = this.getDocumentNames().iterator();
            this.routingSelector = it.next();
            StringBuilder sb = new StringBuilder(this.routingSelector);
            while (it.hasNext()) {
                sb.append(" or ").append(it.next());
            }
            this.routingSelector = sb.toString();
        }
    }

    @Override
    protected void deriveAllSearchDefinitions(List<AbstractSearchCluster.SearchDefinitionSpec> localSearches, DeployState deployState) {
        for (AbstractSearchCluster.SearchDefinitionSpec spec : localSearches) {
            Search search = spec.getSearchDefinition().getSearch();
            if (search instanceof DocumentOnlySearch) continue;
            DocumentDatabase db = new DocumentDatabase(this, search.getName(), new DerivedConfiguration(search, deployState.getDeployLogger(), deployState.getProperties(), deployState.rankProfileRegistry(), deployState.getQueryProfiles().getRegistry(), deployState.getImportedModels()));
            db.mergeUserConfigs(spec.getUserConfigs());
            this.documentDbs.add(db);
        }
    }

    public List<DocumentDatabase> getDocumentDbs() {
        return this.documentDbs;
    }

    public boolean hasDocumentDB(String name) {
        for (DocumentDatabase db : this.documentDbs) {
            if (!db.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void setSearchCoverage(SearchCoverage searchCoverage) {
        this.searchCoverage = searchCoverage;
    }

    @Override
    public DerivedConfiguration getSdConfig() {
        return null;
    }

    @Override
    public void getConfig(IndexInfoConfig.Builder builder) {
        this.unionCfg.getConfig(builder);
    }

    @Override
    public void getConfig(IlscriptsConfig.Builder builder) {
        this.unionCfg.getConfig(builder);
    }

    @Override
    public void getConfig(AttributesConfig.Builder builder) {
        this.unionCfg.getConfig(builder);
    }

    @Override
    public void getConfig(RankProfilesConfig.Builder builder) {
        this.unionCfg.getConfig(builder);
    }

    @Override
    protected void exportSdFiles(File toDir) {
    }

    boolean useFixedRowInDispatch() {
        for (SearchNode node : this.getSearchNodes()) {
            if (node.getNodeSpec().groupIndex() <= 0) continue;
            return true;
        }
        return false;
    }

    int getMaxNodesDownPerFixedRow() {
        return this.maxNodesDownPerFixedRow;
    }

    public void setMaxNodesDownPerFixedRow(int value) {
        this.maxNodesDownPerFixedRow = value;
    }

    public int getSearchableCopies() {
        return this.searchableCopies;
    }

    public void setSearchableCopies(int searchableCopies) {
        this.searchableCopies = searchableCopies;
    }

    public void setDispatchSpec(DispatchSpec dispatchSpec) {
        this.dispatchSpec = dispatchSpec.getNumDispatchGroups() != null ? new DispatchSpec.Builder().setGroups(DispatchGroupBuilder.createDispatchGroups(this.getSearchNodes(), dispatchSpec.getNumDispatchGroups())).build() : dispatchSpec;
    }

    public DispatchSpec getDispatchSpec() {
        return this.dispatchSpec;
    }

    public void getConfig(DispatchConfig.Builder builder) {
        for (SearchNode node : this.getSearchNodes()) {
            DispatchConfig.Node.Builder nodeBuilder = new DispatchConfig.Node.Builder();
            nodeBuilder.key(node.getDistributionKey());
            nodeBuilder.group(node.getNodeSpec().groupIndex());
            nodeBuilder.host(node.getHostName());
            nodeBuilder.port(node.getRpcPort());
            builder.node(nodeBuilder);
        }
        if (this.useAdaptiveDispatch) {
            builder.distributionPolicy(DispatchConfig.DistributionPolicy.ADAPTIVE);
        }
        if (this.tuning.dispatch.minActiveDocsCoverage != null) {
            builder.minActivedocsPercentage(this.tuning.dispatch.minActiveDocsCoverage.doubleValue());
        }
        if (this.tuning.dispatch.minGroupCoverage != null) {
            builder.minGroupCoverage(this.tuning.dispatch.minGroupCoverage.doubleValue());
        }
        if (this.tuning.dispatch.policy != null) {
            switch (this.tuning.dispatch.policy) {
                case ADAPTIVE: {
                    builder.distributionPolicy(DispatchConfig.DistributionPolicy.ADAPTIVE);
                    break;
                }
                case ROUNDROBIN: {
                    builder.distributionPolicy(DispatchConfig.DistributionPolicy.ROUNDROBIN);
                }
            }
        }
        if (this.tuning.dispatch.maxHitsPerPartition != null) {
            builder.maxHitsPerNode(this.tuning.dispatch.maxHitsPerPartition.intValue());
        }
        builder.maxNodesDownPerGroup(this.rootDispatch.getMaxNodesDownPerFixedRow());
        builder.useLocalNode(this.tuning.dispatch.useLocalNode);
        builder.searchableCopies((long)this.rootDispatch.getSearchableCopies());
        if (this.searchCoverage != null) {
            if (this.searchCoverage.getMinimum() != null) {
                builder.minSearchCoverage(this.searchCoverage.getMinimum() * 100.0);
            }
            if (this.searchCoverage.getMinWaitAfterCoverageFactor() != null) {
                builder.minWaitAfterCoverageFactor(this.searchCoverage.getMinWaitAfterCoverageFactor().doubleValue());
            }
            if (this.searchCoverage.getMaxWaitAfterCoverageFactor() != null) {
                builder.maxWaitAfterCoverageFactor(this.searchCoverage.getMaxWaitAfterCoverageFactor().doubleValue());
            }
        }
    }

    @Override
    protected void assureSdConsistent() {
    }

    @Override
    public int getRowBits() {
        return 8;
    }

    public static class UnionConfiguration
    extends AbstractConfigProducer
    implements AttributesConfig.Producer {
        private final List<DocumentDatabase> docDbs;

        public void getConfig(IndexInfoConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(IlscriptsConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(AttributesConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(RankProfilesConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        private UnionConfiguration(AbstractConfigProducer parent, List<DocumentDatabase> docDbs) {
            super(parent, "union");
            this.docDbs = docDbs;
        }
    }
}

