/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.collections.Pair;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.osgi.provider.model.ComponentModel;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class Component<CHILD extends AbstractConfigProducer<?>, MODEL extends ComponentModel>
extends AbstractConfigProducer<CHILD>
implements Comparable<Component<?, ?>> {
    public final MODEL model;
    final Set<Pair<String, Component>> injectedComponents = new LinkedHashSet<Pair<String, Component>>();

    public Component(MODEL model) {
        super(model.getComponentId().stringValue());
        this.model = model;
    }

    public ComponentId getGlobalComponentId() {
        return this.model.getComponentId();
    }

    public ComponentId getComponentId() {
        return this.model.getComponentId();
    }

    public ComponentSpecification getClassId() {
        return this.model.getClassId();
    }

    public void inject(Component component) {
        this.injectForName("", component);
    }

    public void injectForName(String name, Component component) {
        this.injectedComponents.add((Pair<String, Component>)new Pair((Object)name, (Object)component));
    }

    public void addComponent(CHILD child) {
        this.addChild(child);
    }

    public Set<String> getInjectedComponentIds() {
        HashSet<String> injectedIds = new HashSet<String>();
        for (Pair<String, Component> injected : this.injectedComponents) {
            injectedIds.add(((Component)injected.getSecond()).getSubId());
        }
        return injectedIds;
    }

    @Override
    public int compareTo(Component<?, ?> other) {
        return this.getComponentId().compareTo(other.getComponentId());
    }
}

