/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModels;
import com.google.common.collect.ImmutableList;
import com.yahoo.collections.Pair;
import com.yahoo.compress.Compressor;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.FieldRankSettings;
import com.yahoo.searchdefinition.derived.NativeRankTypeDefinition;
import com.yahoo.searchdefinition.derived.NativeRankTypeDefinitionSet;
import com.yahoo.searchdefinition.derived.NativeTable;
import com.yahoo.searchdefinition.document.RankType;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RawRankProfile
implements RankProfilesConfig.Producer {
    private static final Compressor compressor = new Compressor();
    private final String keyEndMarker = "\r=";
    private final String valueEndMarker = "\r\n";
    public static final String summaryFeatureFefPropertyPrefix = "vespa.summary.feature";
    public static final String rankFeatureFefPropertyPrefix = "vespa.dump.feature";
    private final String name;
    private final Compressor.Compression compressedProperties;

    public RawRankProfile(RankProfile rankProfile, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels, AttributeFields attributeFields, ModelContext.Properties deployProperties) {
        this.name = rankProfile.getName();
        this.compressedProperties = this.compress(new Deriver(rankProfile, queryProfiles, importedModels, attributeFields, deployProperties).derive());
    }

    public RawRankProfile(RankProfile rankProfile, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels, AttributeFields attributeFields) {
        this(rankProfile, queryProfiles, importedModels, attributeFields, new TestProperties());
    }

    private Compressor.Compression compress(List<Pair<String, String>> properties) {
        StringBuilder b = new StringBuilder();
        for (Pair<String, String> property : properties) {
            b.append((String)property.getFirst()).append("\r=").append((String)property.getSecond()).append("\r\n");
        }
        return compressor.compress(b.toString().getBytes(StandardCharsets.UTF_8));
    }

    private List<Pair<String, String>> decompress(Compressor.Compression compression) {
        String propertiesString = new String(compressor.decompress(compression), StandardCharsets.UTF_8);
        if (propertiesString.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder properties = new ImmutableList.Builder();
        int pos = 0;
        while (pos < propertiesString.length()) {
            int keyEndPos = propertiesString.indexOf("\r=", pos);
            String key = propertiesString.substring(pos, keyEndPos);
            pos = keyEndPos + "\r=".length();
            int valueEndPos = propertiesString.indexOf("\r\n", pos);
            String value = propertiesString.substring(pos, valueEndPos);
            pos = valueEndPos + "\r\n".length();
            properties.add((Object)new Pair((Object)key, (Object)value));
        }
        return properties.build();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return " rank profile " + this.name;
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        RankProfilesConfig.Rankprofile.Builder b = new RankProfilesConfig.Rankprofile.Builder().name(this.getName());
        this.getRankProperties(b);
        builder.rankprofile(b);
    }

    private void getRankProperties(RankProfilesConfig.Rankprofile.Builder b) {
        RankProfilesConfig.Rankprofile.Fef.Builder fefB = new RankProfilesConfig.Rankprofile.Fef.Builder();
        for (Pair<String, String> p : this.decompress(this.compressedProperties)) {
            fefB.property(new RankProfilesConfig.Rankprofile.Fef.Property.Builder().name((String)p.getFirst()).value((String)p.getSecond()));
        }
        b.fef(fefB);
    }

    public List<Pair<String, String>> configProperties() {
        return this.decompress(this.compressedProperties);
    }

    private static class Deriver {
        private Map<String, FieldRankSettings> fieldRankSettings = new LinkedHashMap<String, FieldRankSettings>();
        private RankingExpression firstPhaseRanking = null;
        private RankingExpression secondPhaseRanking = null;
        private Set<ReferenceNode> summaryFeatures = new LinkedHashSet<ReferenceNode>();
        private Set<ReferenceNode> rankFeatures = new LinkedHashSet<ReferenceNode>();
        private List<RankProfile.RankProperty> rankProperties = new ArrayList<RankProfile.RankProperty>();
        private List<RankProfile.RankProperty> boostAndWeightRankProperties = new ArrayList<RankProfile.RankProperty>();
        private boolean ignoreDefaultRankFeatures = false;
        private RankProfile.MatchPhaseSettings matchPhaseSettings = null;
        private int rerankCount = -1;
        private int keepRankCount = -1;
        private int numThreadsPerSearch = -1;
        private int minHitsPerThread = -1;
        private int numSearchPartitions = -1;
        private double termwiseLimit = 1.0;
        private double rankScoreDropLimit = -1.7976931348623157E308;
        private final NativeRankTypeDefinitionSet nativeRankTypeDefinitions = new NativeRankTypeDefinitionSet("default");
        private final Map<String, String> attributeTypes;
        private final Map<String, String> queryFeatureTypes;
        private Set<String> filterFields = new LinkedHashSet<String>();

        Deriver(RankProfile rankProfile, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels, AttributeFields attributeFields, ModelContext.Properties deployProperties) {
            RankProfile compiled = rankProfile.compile(queryProfiles, importedModels);
            this.attributeTypes = compiled.getAttributeTypes();
            this.queryFeatureTypes = compiled.getQueryFeatureTypes();
            this.deriveRankingFeatures(compiled, deployProperties);
            this.deriveRankTypeSetting(compiled, attributeFields);
            this.deriveFilterFields(compiled);
            this.deriveWeightProperties(compiled);
        }

        private void deriveFilterFields(RankProfile rp) {
            this.filterFields.addAll(rp.allFilterFields());
        }

        private void deriveRankingFeatures(RankProfile rankProfile, ModelContext.Properties deployProperties) {
            this.firstPhaseRanking = rankProfile.getFirstPhaseRanking();
            this.secondPhaseRanking = rankProfile.getSecondPhaseRanking();
            this.summaryFeatures = new LinkedHashSet<ReferenceNode>(rankProfile.getSummaryFeatures());
            this.rankFeatures = rankProfile.getRankFeatures();
            this.rerankCount = rankProfile.getRerankCount();
            this.matchPhaseSettings = rankProfile.getMatchPhaseSettings();
            this.numThreadsPerSearch = rankProfile.getNumThreadsPerSearch();
            this.minHitsPerThread = rankProfile.getMinHitsPerThread();
            this.numSearchPartitions = rankProfile.getNumSearchPartitions();
            this.termwiseLimit = rankProfile.getTermwiseLimit().orElse(deployProperties.defaultTermwiseLimit());
            this.keepRankCount = rankProfile.getKeepRankCount();
            this.rankScoreDropLimit = rankProfile.getRankScoreDropLimit();
            this.ignoreDefaultRankFeatures = rankProfile.getIgnoreDefaultRankFeatures();
            this.rankProperties = new ArrayList<RankProfile.RankProperty>(rankProfile.getRankProperties());
            this.derivePropertiesAndSummaryFeaturesFromFunctions(rankProfile.getFunctions());
        }

        private void derivePropertiesAndSummaryFeaturesFromFunctions(Map<String, RankProfile.RankingExpressionFunction> functions) {
            if (functions.isEmpty()) {
                return;
            }
            List<ExpressionFunction> functionExpressions = functions.values().stream().map(f -> f.function()).collect(Collectors.toList());
            LinkedHashMap<String, String> functionProperties = new LinkedHashMap<String, String>();
            functionProperties.putAll(this.deriveFunctionProperties(functions, functionExpressions));
            if (this.firstPhaseRanking != null) {
                functionProperties.putAll(this.firstPhaseRanking.getRankProperties(functionExpressions));
            }
            if (this.secondPhaseRanking != null) {
                functionProperties.putAll(this.secondPhaseRanking.getRankProperties(functionExpressions));
            }
            for (Map.Entry e : functionProperties.entrySet()) {
                this.rankProperties.add(new RankProfile.RankProperty((String)e.getKey(), (String)e.getValue()));
            }
            SerializationContext context = new SerializationContext(functionExpressions, null, functionProperties);
            this.replaceFunctionSummaryFeatures(context);
        }

        private Map<String, String> deriveFunctionProperties(Map<String, RankProfile.RankingExpressionFunction> functions, List<ExpressionFunction> functionExpressions) {
            SerializationContext context = new SerializationContext(functionExpressions);
            for (Map.Entry<String, RankProfile.RankingExpressionFunction> e : functions.entrySet()) {
                String expressionString = e.getValue().function().getBody().getRoot().toString(new StringBuilder(), context, null, null).toString();
                context.addFunctionSerialization(RankingExpression.propertyName((String)e.getKey()), expressionString);
                for (Map.Entry argumentType : e.getValue().function().argumentTypes().entrySet()) {
                    context.addArgumentTypeSerialization(e.getKey(), (String)argumentType.getKey(), (TensorType)argumentType.getValue());
                }
                if (!e.getValue().function().returnType().isPresent()) continue;
                context.addFunctionTypeSerialization(e.getKey(), (TensorType)e.getValue().function().returnType().get());
            }
            return context.serializedFunctions();
        }

        private void replaceFunctionSummaryFeatures(SerializationContext context) {
            if (this.summaryFeatures == null) {
                return;
            }
            LinkedHashMap<String, ReferenceNode> functionSummaryFeatures = new LinkedHashMap<String, ReferenceNode>();
            Iterator<ReferenceNode> i = this.summaryFeatures.iterator();
            while (i.hasNext()) {
                ReferenceNode referenceNode = i.next();
                if (context.getFunction(referenceNode.getName()) == null) continue;
                context.addFunctionSerialization(RankingExpression.propertyName((String)referenceNode.getName()), referenceNode.toString(new StringBuilder(), context, null, null).toString());
                ReferenceNode newReferenceNode = new ReferenceNode("rankingExpression(" + referenceNode.getName() + ")", referenceNode.getArguments().expressions(), referenceNode.getOutput());
                functionSummaryFeatures.put(referenceNode.getName(), newReferenceNode);
                i.remove();
            }
            for (Map.Entry e : functionSummaryFeatures.entrySet()) {
                this.summaryFeatures.add((ReferenceNode)e.getValue());
            }
        }

        private void deriveWeightProperties(RankProfile rankProfile) {
            for (RankProfile.RankSetting setting : rankProfile.rankSettings()) {
                if (!setting.getType().equals((Object)RankProfile.RankSetting.Type.WEIGHT)) continue;
                this.boostAndWeightRankProperties.add(new RankProfile.RankProperty("vespa.fieldweight." + setting.getFieldName(), String.valueOf(setting.getIntValue())));
            }
        }

        private void deriveRankTypeSetting(RankProfile rankProfile, AttributeFields attributeFields) {
            Iterator<RankProfile.RankSetting> i = rankProfile.rankSettingIterator();
            while (i.hasNext()) {
                RankProfile.RankSetting setting = i.next();
                if (!setting.getType().equals((Object)RankProfile.RankSetting.Type.RANKTYPE)) continue;
                this.deriveNativeRankTypeSetting(setting.getFieldName(), (RankType)((Object)setting.getValue()), attributeFields, this.hasDefaultRankTypeSetting(rankProfile, setting.getFieldName()));
            }
        }

        private void deriveNativeRankTypeSetting(String fieldName, RankType rankType, AttributeFields attributeFields, boolean isDefaultSetting) {
            if (isDefaultSetting) {
                return;
            }
            NativeRankTypeDefinition definition = this.nativeRankTypeDefinitions.getRankTypeDefinition(rankType);
            if (definition == null) {
                throw new IllegalArgumentException("In field '" + fieldName + "': " + rankType + " is known but has no implementation. Supported rank types: " + this.nativeRankTypeDefinitions.types().keySet());
            }
            FieldRankSettings settings = this.deriveFieldRankSettings(fieldName);
            Iterator<NativeTable> i = definition.rankSettingIterator();
            while (i.hasNext()) {
                NativeTable table = i.next();
                if ((!FieldRankSettings.isIndexFieldTable(table) || attributeFields.getAttribute(fieldName) != null) && (!FieldRankSettings.isAttributeFieldTable(table) || attributeFields.getAttribute(fieldName) == null)) continue;
                settings.addTable(table);
            }
        }

        private boolean hasDefaultRankTypeSetting(RankProfile rankProfile, String fieldName) {
            RankProfile.RankSetting setting = rankProfile.getRankSetting(fieldName, RankProfile.RankSetting.Type.RANKTYPE);
            return setting != null && setting.getValue().equals((Object)RankType.DEFAULT);
        }

        private FieldRankSettings deriveFieldRankSettings(String fieldName) {
            FieldRankSettings settings = this.fieldRankSettings.get(fieldName);
            if (settings == null) {
                settings = new FieldRankSettings(fieldName);
                this.fieldRankSettings.put(fieldName, settings);
            }
            return settings;
        }

        public List<Pair<String, String>> derive() {
            ArrayList<Pair<String, String>> properties = new ArrayList<Pair<String, String>>();
            for (RankProfile.RankProperty property : this.rankProperties) {
                if ("rankingExpression(firstphase).rankingScript".equals(property.getName())) {
                    try {
                        this.firstPhaseRanking = new RankingExpression(property.getValue());
                        continue;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Could not parse second phase expression", e);
                    }
                }
                if ("rankingExpression(secondphase).rankingScript".equals(property.getName())) {
                    try {
                        this.secondPhaseRanking = new RankingExpression(property.getValue());
                        continue;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Could not parse second phase expression", e);
                    }
                }
                properties.add(new Pair((Object)property.getName(), (Object)property.getValue()));
            }
            properties.addAll(this.deriveRankingPhaseRankProperties(this.firstPhaseRanking, "firstphase"));
            properties.addAll(this.deriveRankingPhaseRankProperties(this.secondPhaseRanking, "secondphase"));
            for (FieldRankSettings settings : this.fieldRankSettings.values()) {
                properties.addAll(settings.deriveRankProperties());
            }
            for (RankProfile.RankProperty property : this.boostAndWeightRankProperties) {
                properties.add(new Pair((Object)property.getName(), (Object)property.getValue()));
            }
            for (ReferenceNode feature : this.summaryFeatures) {
                properties.add(new Pair((Object)RawRankProfile.summaryFeatureFefPropertyPrefix, (Object)feature.toString()));
            }
            for (ReferenceNode feature : this.rankFeatures) {
                properties.add(new Pair((Object)RawRankProfile.rankFeatureFefPropertyPrefix, (Object)feature.toString()));
            }
            if (this.numThreadsPerSearch > 0) {
                properties.add(new Pair((Object)"vespa.matching.numthreadspersearch", (Object)("" + this.numThreadsPerSearch)));
            }
            if (this.minHitsPerThread > 0) {
                properties.add(new Pair((Object)"vespa.matching.minhitsperthread", (Object)("" + this.minHitsPerThread)));
            }
            if (this.numSearchPartitions >= 0) {
                properties.add(new Pair((Object)"vespa.matching.numsearchpartitions", (Object)("" + this.numSearchPartitions)));
            }
            if (this.termwiseLimit < 1.0) {
                properties.add(new Pair((Object)"vespa.matching.termwise_limit", (Object)("" + this.termwiseLimit)));
            }
            if (this.matchPhaseSettings != null) {
                properties.add(new Pair((Object)"vespa.matchphase.degradation.attribute", (Object)this.matchPhaseSettings.getAttribute()));
                properties.add(new Pair((Object)"vespa.matchphase.degradation.ascendingorder", (Object)("" + this.matchPhaseSettings.getAscending())));
                properties.add(new Pair((Object)"vespa.matchphase.degradation.maxhits", (Object)("" + this.matchPhaseSettings.getMaxHits())));
                properties.add(new Pair((Object)"vespa.matchphase.degradation.maxfiltercoverage", (Object)("" + this.matchPhaseSettings.getMaxFilterCoverage())));
                properties.add((Pair<String, String>)new Pair((Object)"vespa.matchphase.degradation.samplepercentage", (Object)("" + this.matchPhaseSettings.getEvaluationPoint())));
                properties.add((Pair<String, String>)new Pair((Object)"vespa.matchphase.degradation.postfiltermultiplier", (Object)("" + this.matchPhaseSettings.getPrePostFilterTippingPoint())));
                RankProfile.DiversitySettings diversitySettings = this.matchPhaseSettings.getDiversity();
                if (diversitySettings != null) {
                    properties.add((Pair<String, String>)new Pair((Object)"vespa.matchphase.diversity.attribute", (Object)diversitySettings.getAttribute()));
                    properties.add((Pair<String, String>)new Pair((Object)"vespa.matchphase.diversity.mingroups", (Object)String.valueOf(diversitySettings.getMinGroups())));
                    properties.add((Pair<String, String>)new Pair((Object)"vespa.matchphase.diversity.cutoff.factor", (Object)String.valueOf(diversitySettings.getCutoffFactor())));
                    properties.add((Pair<String, String>)new Pair((Object)"vespa.matchphase.diversity.cutoff.strategy", (Object)String.valueOf(diversitySettings.getCutoffStrategy())));
                }
            }
            if (this.rerankCount > -1) {
                properties.add(new Pair((Object)"vespa.hitcollector.heapsize", (Object)("" + this.rerankCount)));
            }
            if (this.keepRankCount > -1) {
                properties.add(new Pair((Object)"vespa.hitcollector.arraysize", (Object)("" + this.keepRankCount)));
            }
            if (this.rankScoreDropLimit > -1.7976931348623157E308) {
                properties.add(new Pair((Object)"vespa.hitcollector.rankscoredroplimit", (Object)("" + this.rankScoreDropLimit)));
            }
            if (this.ignoreDefaultRankFeatures) {
                properties.add(new Pair((Object)"vespa.dump.ignoredefaultfeatures", (Object)String.valueOf(true)));
            }
            for (String fieldName : this.filterFields) {
                properties.add(new Pair((Object)("vespa.isfilterfield." + fieldName), (Object)String.valueOf(true)));
            }
            for (Map.Entry<String, String> attributeType : this.attributeTypes.entrySet()) {
                properties.add((Pair<String, String>)new Pair((Object)("vespa.type.attribute." + attributeType.getKey()), (Object)attributeType.getValue()));
            }
            for (Map.Entry<String, String> queryFeatureType : this.queryFeatureTypes.entrySet()) {
                properties.add((Pair<String, String>)new Pair((Object)("vespa.type.query." + queryFeatureType.getKey()), (Object)queryFeatureType.getValue()));
            }
            if (properties.size() >= 1000000) {
                throw new RuntimeException("Too many rank properties");
            }
            return properties;
        }

        private List<Pair<String, String>> deriveRankingPhaseRankProperties(RankingExpression expression, String phase) {
            ArrayList<Pair<String, String>> properties = new ArrayList<Pair<String, String>>();
            if (expression == null) {
                return properties;
            }
            String name = expression.getName();
            if ("".equals(name)) {
                name = phase;
            }
            if (expression.getRoot() instanceof ReferenceNode) {
                properties.add((Pair<String, String>)new Pair((Object)("vespa.rank." + phase), (Object)expression.getRoot().toString()));
            } else {
                properties.add((Pair<String, String>)new Pair((Object)("vespa.rank." + phase), (Object)("rankingExpression(" + name + ")")));
                properties.add((Pair<String, String>)new Pair((Object)("rankingExpression(" + name + ").rankingScript"), (Object)expression.getRoot().toString()));
            }
            return properties;
        }
    }
}

