/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.searchdefinition.derived.DerivedConfiguration;
import com.yahoo.searchdefinition.derived.SummaryMap;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.config.search.SummarymapConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class SearchCluster
extends AbstractSearchCluster
implements DocumentdbInfoConfig.Producer,
IndexInfoConfig.Producer,
IlscriptsConfig.Producer {
    private static final long serialVersionUID = 1L;

    protected SearchCluster(AbstractConfigProducer parent, String clusterName, int index) {
        super(parent, clusterName, index);
    }

    @Override
    public void writeFiles(File directory) throws IOException {
        if (!directory.isDirectory() && !directory.mkdirs()) {
            throw new IOException("Cannot create directory: " + directory);
        }
        this.writeSdFiles(directory);
        super.writeFiles(directory);
    }

    public void deriveSearchDefinitions(DeployState deployState) {
        this.deriveAllSearchDefinitions(this.getLocalSDS(), deployState);
    }

    @Override
    public void getConfig(IndexInfoConfig.Builder builder) {
        if (this.getSdConfig() != null) {
            this.getSdConfig().getIndexInfo().getConfig(builder);
        }
    }

    @Override
    public void getConfig(IlscriptsConfig.Builder builder) {
        if (this.getSdConfig() != null) {
            this.getSdConfig().getIndexingScript().getConfig(builder);
        }
    }

    @Override
    public void getConfig(AttributesConfig.Builder builder) {
        if (this.getSdConfig() != null) {
            this.getSdConfig().getAttributeFields().getConfig(builder);
        }
    }

    @Override
    public void getConfig(RankProfilesConfig.Builder builder) {
        if (this.getSdConfig() != null) {
            this.getSdConfig().getRankProfileList().getConfig(builder);
        }
    }

    protected void convertSummaryConfig(SummaryConfig.Producer summaryConfigProducer, SummarymapConfig.Producer summarymapConfigProducer, DocumentdbInfoConfig.Documentdb.Builder docDb) {
        SummaryConfig.Builder summaryConfigBuilder = new SummaryConfig.Builder();
        summaryConfigProducer.getConfig(summaryConfigBuilder);
        SummaryConfig summaryConfig = new SummaryConfig(summaryConfigBuilder);
        SummarymapConfig summarymapConfig = null;
        if (summarymapConfigProducer != null) {
            SummarymapConfig.Builder summarymapConfigBuilder = new SummarymapConfig.Builder();
            summarymapConfigProducer.getConfig(summarymapConfigBuilder);
            summarymapConfig = new SummarymapConfig(summarymapConfigBuilder);
        }
        for (SummaryConfig.Classes sclass : summaryConfig.classes()) {
            DocumentdbInfoConfig.Documentdb.Summaryclass.Builder sumClassBuilder = new DocumentdbInfoConfig.Documentdb.Summaryclass.Builder();
            sumClassBuilder.id(sclass.id()).name(sclass.name());
            for (SummaryConfig.Classes.Fields field : sclass.fields()) {
                DocumentdbInfoConfig.Documentdb.Summaryclass.Fields.Builder fieldsBuilder = new DocumentdbInfoConfig.Documentdb.Summaryclass.Fields.Builder();
                fieldsBuilder.name(field.name()).type(field.type()).dynamic(this.isDynamic(field.name(), summarymapConfig));
                sumClassBuilder.fields(fieldsBuilder);
            }
            docDb.summaryclass(sumClassBuilder);
        }
    }

    private boolean isDynamic(String fieldName, SummarymapConfig summarymapConfig) {
        if (summarymapConfig == null) {
            return false;
        }
        for (SummarymapConfig.Override override : summarymapConfig.override()) {
            if (!fieldName.equals(override.field()) || !SummaryMap.isDynamicCommand(override.command())) continue;
            return true;
        }
        return false;
    }

    protected void addRankProfilesConfig(DocumentdbInfoConfig.Documentdb.Builder docDbBuilder, RankProfilesConfig rankProfilesCfg) {
        for (RankProfilesConfig.Rankprofile rankProfile : rankProfilesCfg.rankprofile()) {
            DocumentdbInfoConfig.Documentdb.Rankprofile.Builder rpB = new DocumentdbInfoConfig.Documentdb.Rankprofile.Builder();
            rpB.name(rankProfile.name());
            rpB.hasSummaryFeatures(this.containsPropertiesWithPrefix("vespa.summary.feature", rankProfile.fef()));
            rpB.hasRankFeatures(this.containsPropertiesWithPrefix("vespa.dump.feature", rankProfile.fef()));
            docDbBuilder.rankprofile(rpB);
        }
    }

    private boolean containsPropertiesWithPrefix(String prefix, RankProfilesConfig.Rankprofile.Fef fef) {
        for (RankProfilesConfig.Rankprofile.Fef.Property p : fef.property()) {
            if (!p.name().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected abstract void deriveAllSearchDefinitions(List<AbstractSearchCluster.SearchDefinitionSpec> var1, DeployState var2);

    public abstract void defaultDocumentsConfig();

    public abstract DerivedConfiguration getSdConfig();

    protected abstract void exportSdFiles(File var1) throws IOException;

    protected final void writeSdFiles(File toDir) throws IOException {
        this.assureSdConsistent();
        this.exportSdFiles(toDir);
    }
}

