/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.xml;

import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.ssl.CustomSslProvider;
import com.yahoo.vespa.model.container.http.ssl.DefaultSslProvider;
import com.yahoo.vespa.model.container.http.ssl.LegacySslProvider;
import com.yahoo.vespa.model.container.http.xml.HttpBuilder;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class JettyConnectorBuilder
extends VespaDomBuilder.DomConfigProducerBuilder<ConnectorFactory> {
    private static final Logger log = Logger.getLogger(JettyConnectorBuilder.class.getName());

    @Override
    protected ConnectorFactory doBuild(DeployState deployState, AbstractConfigProducer ancestor, Element serverSpec) {
        String name = XmlHelper.getIdString(serverSpec);
        int port = HttpBuilder.readPort(serverSpec, deployState.isHosted(), deployState.getDeployLogger());
        Element legacyServerConfig = XML.getChild((Element)serverSpec, (String)"config");
        if (legacyServerConfig != null) {
            String configName = legacyServerConfig.getAttribute("name");
            if (configName.equals("container.jdisc.config.http-server")) {
                deployState.getDeployLogger().log(Level.WARNING, "The config 'container.jdisc.config.http-server' is deprecated and will be removed in a later version of Vespa. Please use 'jdisc.http.connector' instead, see http://docs.vespa.ai/documentation/jdisc/http-server-and-filters.html#configuring-jetty-server");
            } else {
                legacyServerConfig = null;
            }
        }
        SimpleComponent sslProviderComponent = this.getSslConfigComponents(name, serverSpec);
        return new ConnectorFactory(name, port, legacyServerConfig, sslProviderComponent);
    }

    SimpleComponent getSslConfigComponents(String serverName, Element serverSpec) {
        Element sslConfigurator = XML.getChild((Element)serverSpec, (String)"ssl");
        Element sslProviderConfigurator = XML.getChild((Element)serverSpec, (String)"ssl-provider");
        if (sslConfigurator != null) {
            String privateKeyFile = XML.getValue((Element)XML.getChild((Element)sslConfigurator, (String)"private-key-file"));
            String certificateFile = XML.getValue((Element)XML.getChild((Element)sslConfigurator, (String)"certificate-file"));
            Optional<String> caCertificateFile = XmlHelper.getOptionalChildValue(sslConfigurator, "ca-certificates-file");
            Optional<String> clientAuthentication = XmlHelper.getOptionalChildValue(sslConfigurator, "client-authentication");
            return new DefaultSslProvider(serverName, privateKeyFile, certificateFile, caCertificateFile.orElse(null), clientAuthentication.orElse(null));
        }
        if (sslProviderConfigurator != null) {
            String className = sslProviderConfigurator.getAttribute("class");
            String bundle = sslProviderConfigurator.getAttribute("bundle");
            return new CustomSslProvider(serverName, className, bundle);
        }
        return new LegacySslProvider(serverName);
    }
}

