/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.container.core.AccessLogConfig;
import com.yahoo.container.logging.JSONAccessLog;
import com.yahoo.container.logging.VespaAccessLog;
import com.yahoo.container.logging.YApacheAccessLog;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import edu.umd.cs.findbugs.annotations.Nullable;

public final class AccessLogComponent
extends SimpleComponent
implements AccessLogConfig.Producer {
    private final String fileNamePattern;
    private final String rotationInterval;
    private final AccessLogConfig.FileHandler.RotateScheme.Enum rotationScheme;
    private final Boolean compression;
    private final boolean isHostedVespa;
    private final String symlinkName;

    public AccessLogComponent(AccessLogType logType, String clusterName, boolean isHostedVespa) {
        this(logType, String.format("logs/vespa/qrs/%s.%s.%s", AccessLogComponent.capitalize(logType.name()), clusterName, "%Y%m%d%H%M%S"), null, null, null, isHostedVespa, AccessLogComponent.capitalize(logType.name()) + "." + clusterName);
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public AccessLogComponent(AccessLogType logType, String fileNamePattern, String rotationInterval, AccessLogConfig.FileHandler.RotateScheme.Enum rotationScheme, Boolean compressOnRotation, boolean isHostedVespa, String symlinkName) {
        super(new ComponentModel(AccessLogComponent.accessLogClass(logType), null, "container-core", null));
        this.fileNamePattern = fileNamePattern;
        this.rotationInterval = rotationInterval;
        this.rotationScheme = rotationScheme;
        this.compression = compressOnRotation;
        this.isHostedVespa = isHostedVespa;
        this.symlinkName = symlinkName;
        if (fileNamePattern == null) {
            throw new RuntimeException("File name pattern required when configuring access log.");
        }
    }

    private static String accessLogClass(AccessLogType logType) {
        switch (logType) {
            case yApacheAccessLog: {
                return YApacheAccessLog.class.getName();
            }
            case queryAccessLog: {
                return VespaAccessLog.class.getName();
            }
            case jsonAccessLog: {
                return JSONAccessLog.class.getName();
            }
        }
        throw new AssertionError();
    }

    public void getConfig(AccessLogConfig.Builder builder) {
        builder.fileHandler(this.fileHandlerConfig());
    }

    private AccessLogConfig.FileHandler.Builder fileHandlerConfig() {
        AccessLogConfig.FileHandler.Builder builder = new AccessLogConfig.FileHandler.Builder();
        if (this.fileNamePattern != null) {
            builder.pattern(this.fileNamePattern);
        }
        if (this.rotationInterval != null) {
            builder.rotation(this.rotationInterval);
        }
        if (this.rotationScheme != null) {
            builder.rotateScheme(this.rotationScheme);
        }
        if (this.symlinkName != null) {
            builder.symlink(this.symlinkName);
        }
        if (this.compression != null) {
            builder.compressOnRotation(this.compression.booleanValue());
        } else if (this.isHostedVespa) {
            builder.compressOnRotation(true);
        }
        return builder;
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    public static final AccessLogConfig.FileHandler.RotateScheme.Enum rotateScheme(@Nullable String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "date": {
                return AccessLogConfig.FileHandler.RotateScheme.Enum.DATE;
            }
            case "sequence": {
                return AccessLogConfig.FileHandler.RotateScheme.Enum.SEQUENCE;
            }
        }
        throw new IllegalArgumentException("Invalid rotation scheme " + name);
    }

    public static enum AccessLogType {
        queryAccessLog,
        yApacheAccessLog,
        jsonAccessLog;

    }
}

