/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.subscription.ConfigInstanceUtil;
import com.yahoo.document.DataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ComplexAttributeFieldUtils;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.Ranking;
import com.yahoo.searchdefinition.document.Sorting;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.indexinglanguage.expressions.ToPositionExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AttributeFields
extends Derived
implements AttributesConfig.Producer {
    private Map<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();
    private Map<String, Attribute> importedAttributes = new LinkedHashMap<String, Attribute>();
    private boolean hasPosition = false;
    public static final AttributeFields empty = new AttributeFields(null);

    public AttributeFields(Search search) {
        if (search != null) {
            this.derive(search);
        }
    }

    @Override
    protected void derive(ImmutableSDField field, Search search) {
        if (AttributeFields.unsupportedFieldType(field)) {
            return;
        }
        if (field.isImportedField()) {
            this.deriveImportedAttributes(field);
        } else if (ComplexAttributeFieldUtils.isArrayOfSimpleStruct(field)) {
            this.deriveArrayOfSimpleStruct(field);
        } else if (ComplexAttributeFieldUtils.isMapOfSimpleStruct(field)) {
            this.deriveMapOfSimpleStruct(field);
        } else if (ComplexAttributeFieldUtils.isMapOfPrimitiveType(field)) {
            this.deriveMapOfPrimitiveType(field);
        } else {
            this.deriveAttributes(field);
        }
    }

    private static boolean unsupportedFieldType(ImmutableSDField field) {
        return field.usesStructOrMap() && !ComplexAttributeFieldUtils.isSupportedComplexField(field) && !field.getDataType().equals((Object)PositionDataType.INSTANCE) && !field.getDataType().equals((Object)DataType.getArray((DataType)PositionDataType.INSTANCE));
    }

    public Attribute getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public boolean containsAttribute(String attributeName) {
        return this.getAttribute(attributeName) != null;
    }

    private void deriveAttributes(ImmutableSDField field) {
        for (Attribute fieldAttribute : field.getAttributes().values()) {
            this.deriveAttribute(field, fieldAttribute);
        }
        if (field.containsExpression(ToPositionExpression.class)) {
            if (this.hasPosition) {
                throw new IllegalArgumentException("Can not specify more than one set of position attributes per field: " + field.getName());
            }
            this.hasPosition = true;
        }
    }

    private void deriveAttribute(ImmutableSDField field, Attribute fieldAttribute) {
        Ranking ranking;
        Attribute attribute = this.getAttribute(fieldAttribute.getName());
        if (attribute == null) {
            this.attributes.put(fieldAttribute.getName(), fieldAttribute);
            attribute = this.getAttribute(fieldAttribute.getName());
        }
        if ((ranking = field.getRanking()) != null && ranking.isFilter()) {
            attribute.setEnableBitVectors(true);
            attribute.setEnableOnlyBitVector(true);
        }
    }

    private void deriveImportedAttributes(ImmutableSDField field) {
        for (Attribute attribute : field.getAttributes().values()) {
            if (this.importedAttributes.containsKey(field.getName())) continue;
            this.importedAttributes.put(field.getName(), attribute);
        }
    }

    private void deriveArrayOfSimpleStruct(ImmutableSDField field) {
        for (ImmutableSDField immutableSDField : field.getStructFields()) {
            this.deriveAttributeAsArrayType(immutableSDField);
        }
    }

    private void deriveAttributeAsArrayType(ImmutableSDField field) {
        Attribute attribute = field.getAttributes().get(field.getName());
        if (attribute != null) {
            this.attributes.put(attribute.getName(), attribute.convertToArray());
        }
    }

    private void deriveMapOfSimpleStruct(ImmutableSDField field) {
        this.deriveAttributeAsArrayType(field.getStructField("key"));
        this.deriveMapValueField(field.getStructField("value"));
    }

    private void deriveMapValueField(ImmutableSDField valueField) {
        for (ImmutableSDField immutableSDField : valueField.getStructFields()) {
            this.deriveAttributeAsArrayType(immutableSDField);
        }
    }

    private void deriveMapOfPrimitiveType(ImmutableSDField field) {
        this.deriveAttributeAsArrayType(field.getStructField("key"));
        this.deriveAttributeAsArrayType(field.getStructField("value"));
    }

    public Iterator attributeIterator() {
        return this.attributes().iterator();
    }

    public Collection<Attribute> attributes() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    public Collection<Attribute> structFieldAttributes(String baseFieldName) {
        String structPrefix = baseFieldName + ".";
        return this.attributes().stream().filter(attribute -> attribute.getName().startsWith(structPrefix)).collect(Collectors.toList());
    }

    public String toString() {
        return "attributes " + this.getName();
    }

    @Override
    protected String getDerivedName() {
        return "attributes";
    }

    private Map<String, AttributesConfig.Attribute.Builder> toMap(List<AttributesConfig.Attribute.Builder> ls) {
        LinkedHashMap<String, AttributesConfig.Attribute.Builder> ret = new LinkedHashMap<String, AttributesConfig.Attribute.Builder>();
        for (AttributesConfig.Attribute.Builder builder : ls) {
            ret.put((String)ConfigInstanceUtil.getField((ConfigBuilder)builder, (String)"name"), builder);
        }
        return ret;
    }

    public void getConfig(AttributesConfig.Builder builder) {
        this.getConfig(builder, FieldSet.ALL);
    }

    private boolean isAttributeInFieldSet(Attribute attribute, FieldSet fs) {
        return fs == FieldSet.ALL || fs == FieldSet.FAST_ACCESS && attribute.isFastAccess();
    }

    private AttributesConfig.Attribute.Builder getConfig(String attrName, Attribute attribute, boolean imported) {
        AttributesConfig.Attribute.Builder aaB = new AttributesConfig.Attribute.Builder().name(attrName).datatype(AttributesConfig.Attribute.Datatype.Enum.valueOf((String)attribute.getType().getExportAttributeTypeName())).collectiontype(AttributesConfig.Attribute.Collectiontype.Enum.valueOf((String)attribute.getCollectionType().getName()));
        if (attribute.isRemoveIfZero()) {
            aaB.removeifzero(true);
        }
        if (attribute.isCreateIfNonExistent()) {
            aaB.createifnonexistent(true);
        }
        aaB.enablebitvectors(attribute.isEnabledBitVectors());
        aaB.enableonlybitvector(attribute.isEnabledOnlyBitVector());
        if (attribute.isFastSearch()) {
            aaB.fastsearch(true);
        }
        if (attribute.isFastAccess()) {
            aaB.fastaccess(true);
        }
        if (attribute.isMutable()) {
            aaB.ismutable(true);
        }
        if (attribute.isHuge()) {
            aaB.huge(true);
        }
        if (attribute.getSorting().isDescending()) {
            aaB.sortascending(false);
        }
        if (attribute.getSorting().getFunction() != Sorting.Function.UCA) {
            aaB.sortfunction(AttributesConfig.Attribute.Sortfunction.Enum.valueOf((String)attribute.getSorting().getFunction().toString()));
        }
        if (attribute.getSorting().getStrength() != Sorting.Strength.PRIMARY) {
            aaB.sortstrength(AttributesConfig.Attribute.Sortstrength.Enum.valueOf((String)attribute.getSorting().getStrength().toString()));
        }
        if (!attribute.getSorting().getLocale().isEmpty()) {
            aaB.sortlocale(attribute.getSorting().getLocale());
        }
        aaB.arity(attribute.arity());
        aaB.lowerbound(attribute.lowerBound());
        aaB.upperbound(attribute.upperBound());
        aaB.densepostinglistthreshold(attribute.densePostingListThreshold());
        if (attribute.tensorType().isPresent()) {
            aaB.tensortype(attribute.tensorType().get().toString());
        }
        aaB.imported(imported);
        return aaB;
    }

    public void getConfig(AttributesConfig.Builder builder, FieldSet fs) {
        for (Attribute attribute : this.attributes.values()) {
            if (!this.isAttributeInFieldSet(attribute, fs)) continue;
            builder.attribute(this.getConfig(attribute.getName(), attribute, false));
        }
        if (fs == FieldSet.ALL) {
            for (Map.Entry entry : this.importedAttributes.entrySet()) {
                builder.attribute(this.getConfig((String)entry.getKey(), (Attribute)entry.getValue(), true));
            }
        }
    }

    public static enum FieldSet {
        ALL,
        FAST_ACCESS;

    }
}

