/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentmodel;

import com.yahoo.documentmodel.DocumentTypeCollection;
import com.yahoo.documentmodel.NewDocumentType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DocumentTypeRepo
implements DocumentTypeCollection {
    final Map<Integer, NewDocumentType> typeById = new LinkedHashMap<Integer, NewDocumentType>();
    final Map<NewDocumentType.Name, NewDocumentType> typeByName = new LinkedHashMap<NewDocumentType.Name, NewDocumentType>();

    public final NewDocumentType getDocumentType(String name) {
        return this.typeByName.get(new NewDocumentType.Name(name));
    }

    @Override
    public NewDocumentType getDocumentType(NewDocumentType.Name name) {
        return this.typeByName.get(name);
    }

    @Override
    public NewDocumentType getDocumentType(int id) {
        return this.typeById.get(id);
    }

    @Override
    public Collection<NewDocumentType> getTypes() {
        return this.typeById.values();
    }

    public DocumentTypeRepo add(NewDocumentType type) {
        if (this.typeByName.containsKey(type.getFullName())) {
            throw new IllegalStateException("Document type " + type.toString() + " is already registered");
        }
        if (this.typeById.containsKey(type.getFullName().getId())) {
            throw new IllegalStateException("Document type " + type.toString() + " is already registered");
        }
        this.typeByName.put(type.getFullName(), type);
        this.typeById.put(type.getFullName().getId(), type);
        return this;
    }
}

