/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.log.LogLevel;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.searchdefinition.DocumentOnlySearch;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.DerivedConfiguration;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.DispatchConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.SimpleConfigProducer;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.docproc.DocprocChain;
import com.yahoo.vespa.model.content.DispatchSpec;
import com.yahoo.vespa.model.content.SearchCoverage;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.search.Dispatch;
import com.yahoo.vespa.model.search.DispatchGroup;
import com.yahoo.vespa.model.search.DispatchGroupBuilder;
import com.yahoo.vespa.model.search.DocumentDatabase;
import com.yahoo.vespa.model.search.DocumentSelectionConverter;
import com.yahoo.vespa.model.search.SearchCluster;
import com.yahoo.vespa.model.search.SearchNode;
import com.yahoo.vespa.model.search.Tuning;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IndexedSearchCluster
extends SearchCluster
implements DocumentdbInfoConfig.Producer,
IndexInfoConfig.Producer,
IlscriptsConfig.Producer,
DispatchConfig.Producer {
    private static final Logger log = Logger.getLogger(IndexedSearchCluster.class.getName());
    private String indexingClusterName = null;
    private String indexingChainName = null;
    private DocprocChain indexingChain;
    private Tuning tuning;
    private SearchCoverage searchCoverage;
    private String routingSelector = null;
    private List<DocumentDatabase> documentDbs = new LinkedList<DocumentDatabase>();
    private final UnionConfiguration unionCfg;
    private int maxNodesDownPerFixedRow = 0;
    private int searchableCopies = 1;
    private final SimpleConfigProducer dispatchParent;
    private final DispatchGroup rootDispatch;
    private DispatchSpec dispatchSpec;
    private List<SearchNode> searchNodes = new ArrayList<SearchNode>();

    public String getRoutingSelector() {
        return this.routingSelector;
    }

    public IndexedSearchCluster(AbstractConfigProducer parent, String clusterName, int index) {
        super(parent, clusterName, index);
        this.unionCfg = new UnionConfiguration(this, this.documentDbs);
        this.dispatchParent = new SimpleConfigProducer(this, "dispatchers");
        this.rootDispatch = new DispatchGroup(this);
    }

    @Override
    protected AbstractSearchCluster.IndexingMode getIndexingMode() {
        return AbstractSearchCluster.IndexingMode.REALTIME;
    }

    public final boolean hasExplicitIndexingCluster() {
        return this.indexingClusterName != null;
    }

    public final boolean hasExplicitIndexingChain() {
        return this.indexingChainName != null;
    }

    public String getIndexingClusterName() {
        return this.hasExplicitIndexingCluster() ? this.indexingClusterName : this.getClusterName() + ".indexing";
    }

    public String getIndexingChainName() {
        return this.indexingChainName;
    }

    public void setIndexingChainName(String indexingChainName) {
        this.indexingChainName = indexingChainName;
    }

    public void setIndexingClusterName(String name) {
        this.indexingClusterName = name;
    }

    public String getIndexingServiceName() {
        return this.indexingChain.getServiceName();
    }

    public AbstractSearchCluster setIndexingChain(DocprocChain chain) {
        this.indexingChain = chain;
        return this;
    }

    public Dispatch addTld(DeployLogger deployLogger, AbstractConfigProducer tldParent, HostResource hostResource) {
        int index = this.rootDispatch.getDispatchers().size();
        Dispatch tld = Dispatch.createTld(this.rootDispatch, tldParent, index);
        tld.setHostResource(hostResource);
        tld.initService(deployLogger);
        this.rootDispatch.addDispatcher(tld);
        return tld;
    }

    public void addTldsWithSameIdsAsContainers(DeployLogger deployLogger, AbstractConfigProducer tldParent, ContainerCluster containerCluster) {
        for (Container container : containerCluster.getContainers()) {
            String containerSubId = container.getSubId();
            if (!containerSubId.contains(".")) {
                throw new RuntimeException("Expected container sub id to be of the form string.number");
            }
            int containerIndex = Integer.parseInt(containerSubId.split("\\.")[1]);
            String containerClusterName = containerCluster.getName();
            log.log((Level)LogLevel.DEBUG, "Adding tld with index " + containerIndex + " for content cluster " + this.getClusterName() + ", container cluster " + containerClusterName + " (container id " + containerSubId + ") on host " + container.getHostResource().getHostname());
            this.rootDispatch.addDispatcher(this.createTld(deployLogger, tldParent, container.getHostResource(), containerClusterName, containerIndex));
        }
    }

    private Dispatch createTld(DeployLogger deployLogger, AbstractConfigProducer tldParent, HostResource hostResource, String containerClusterName, int containerIndex) {
        Dispatch tld = Dispatch.createTldWithContainerIdInName(this.rootDispatch, tldParent, containerClusterName, containerIndex);
        tld.setHostResource(hostResource);
        tld.initService(deployLogger);
        return tld;
    }

    public DispatchGroup getRootDispatch() {
        return this.rootDispatch;
    }

    public void addSearcher(SearchNode searcher) {
        this.searchNodes.add(searcher);
        this.rootDispatch.addSearcher(searcher);
    }

    public List<Dispatch> getTLDs() {
        return this.rootDispatch.getDispatchers();
    }

    public List<SearchNode> getSearchNodes() {
        return Collections.unmodifiableList(this.searchNodes);
    }

    public int getSearchNodeCount() {
        return this.searchNodes.size();
    }

    public SearchNode getSearchNode(int index) {
        return this.searchNodes.get(index);
    }

    public void setTuning(Tuning tuning) {
        this.tuning = tuning;
    }

    public Tuning getTuning() {
        return this.tuning;
    }

    public void fillDocumentDBConfig(String documentType, ProtonConfig.Documentdb.Builder builder) {
        for (DocumentDatabase sdoc : this.documentDbs) {
            if (!sdoc.getName().equals(documentType)) continue;
            this.fillDocumentDBConfig(sdoc, builder);
            return;
        }
    }

    private void fillDocumentDBConfig(DocumentDatabase sdoc, ProtonConfig.Documentdb.Builder ddbB) {
        ddbB.inputdoctypename(sdoc.getInputDocType()).configid(sdoc.getConfigId()).visibilitydelay(this.getVisibilityDelay().doubleValue());
    }

    @Override
    public void getConfig(DocumentdbInfoConfig.Builder builder) {
        for (DocumentDatabase db : this.documentDbs) {
            DocumentdbInfoConfig.Documentdb.Builder docDb = new DocumentdbInfoConfig.Documentdb.Builder();
            docDb.name(db.getName());
            this.convertSummaryConfig(db, db, docDb);
            RankProfilesConfig.Builder rpb = new RankProfilesConfig.Builder();
            db.getConfig(rpb);
            this.addRankProfilesConfig(docDb, new RankProfilesConfig(rpb));
            builder.documentdb(docDb);
        }
    }

    public void setRoutingSelector(String sel) {
        this.routingSelector = sel;
        if (this.routingSelector != null) {
            try {
                new DocumentSelectionConverter(this.routingSelector);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid routing selector: " + e.getMessage());
            }
        }
    }

    @Override
    public void defaultDocumentsConfig() {
        if (this.routingSelector == null && !this.getDocumentNames().isEmpty()) {
            Iterator<String> it = this.getDocumentNames().iterator();
            this.routingSelector = it.next();
            StringBuilder sb = new StringBuilder(this.routingSelector);
            while (it.hasNext()) {
                sb.append(" or ").append(it.next());
            }
            this.routingSelector = sb.toString();
        }
    }

    @Override
    protected void deriveAllSearchDefinitions(List<AbstractSearchCluster.SearchDefinitionSpec> localSearches, DeployState deployState) {
        for (AbstractSearchCluster.SearchDefinitionSpec spec : localSearches) {
            Search search = spec.getSearchDefinition().getSearch();
            if (search instanceof DocumentOnlySearch) continue;
            DocumentDatabase db = new DocumentDatabase(this, search.getName(), new DerivedConfiguration(search, deployState.getDeployLogger(), deployState.rankProfileRegistry(), deployState.getQueryProfiles().getRegistry(), deployState.getImportedModels()));
            db.mergeUserConfigs(spec.getUserConfigs());
            this.documentDbs.add(db);
        }
    }

    public List<DocumentDatabase> getDocumentDbs() {
        return this.documentDbs;
    }

    public void setSearchCoverage(SearchCoverage searchCoverage) {
        this.searchCoverage = searchCoverage;
    }

    SearchCoverage getSearchCoverage() {
        return this.searchCoverage;
    }

    @Override
    public DerivedConfiguration getSdConfig() {
        return null;
    }

    @Override
    public void getConfig(IndexInfoConfig.Builder builder) {
        this.unionCfg.getConfig(builder);
    }

    @Override
    public void getConfig(IlscriptsConfig.Builder builder) {
        this.unionCfg.getConfig(builder);
    }

    @Override
    public void getConfig(AttributesConfig.Builder builder) {
        this.unionCfg.getConfig(builder);
    }

    @Override
    public void getConfig(RankProfilesConfig.Builder builder) {
        this.unionCfg.getConfig(builder);
    }

    @Override
    protected void exportSdFiles(File toDir) {
    }

    int getMinNodesPerColumn() {
        return 0;
    }

    boolean useFixedRowInDispatch() {
        for (SearchNode node : this.getSearchNodes()) {
            if (node.getNodeSpec().groupIndex() <= 0) continue;
            return true;
        }
        return false;
    }

    int getMaxNodesDownPerFixedRow() {
        return this.maxNodesDownPerFixedRow;
    }

    public void setMaxNodesDownPerFixedRow(int value) {
        this.maxNodesDownPerFixedRow = value;
    }

    int getSearchableCopies() {
        return this.searchableCopies;
    }

    public void setSearchableCopies(int searchableCopies) {
        this.searchableCopies = searchableCopies;
    }

    public void setDispatchSpec(DispatchSpec dispatchSpec) {
        this.dispatchSpec = dispatchSpec.getNumDispatchGroups() != null ? new DispatchSpec.Builder().setGroups(DispatchGroupBuilder.createDispatchGroups(this.getSearchNodes(), dispatchSpec.getNumDispatchGroups())).build() : dispatchSpec;
    }

    public DispatchSpec getDispatchSpec() {
        return this.dispatchSpec;
    }

    public boolean useMultilevelDispatchSetup() {
        return this.dispatchSpec != null && this.dispatchSpec.getGroups() != null && !this.dispatchSpec.getGroups().isEmpty();
    }

    public void setupDispatchGroups(DeployLogger deployLogger) {
        if (!this.useMultilevelDispatchSetup()) {
            return;
        }
        this.rootDispatch.clearSearchers();
        new DispatchGroupBuilder(this.dispatchParent, this.rootDispatch, this).build(deployLogger, this.dispatchSpec.getGroups(), this.getSearchNodes());
    }

    public void getConfig(DispatchConfig.Builder builder) {
        for (SearchNode node : this.getSearchNodes()) {
            DispatchConfig.Node.Builder nodeBuilder = new DispatchConfig.Node.Builder();
            nodeBuilder.key(node.getDistributionKey());
            nodeBuilder.group(node.getNodeSpec().groupIndex());
            nodeBuilder.host(node.getHostName());
            nodeBuilder.port(node.getRpcPort());
            nodeBuilder.fs4port(node.getDispatchPort());
            builder.node(nodeBuilder);
        }
        if (this.tuning.dispatch.minActiveDocsCoverage != null) {
            builder.minActivedocsPercentage(this.tuning.dispatch.minActiveDocsCoverage.doubleValue());
        }
        if (this.tuning.dispatch.minGroupCoverage != null) {
            builder.minGroupCoverage(this.tuning.dispatch.minGroupCoverage.doubleValue());
        }
        if (this.tuning.dispatch.policy != null) {
            switch (this.tuning.dispatch.policy) {
                case RANDOM: {
                    builder.distributionPolicy(DispatchConfig.DistributionPolicy.RANDOM);
                    break;
                }
                case ROUNDROBIN: {
                    builder.distributionPolicy(DispatchConfig.DistributionPolicy.ROUNDROBIN);
                }
            }
        }
        builder.maxNodesDownPerGroup(this.rootDispatch.getMaxNodesDownPerFixedRow());
        builder.useMultilevelDispatch(this.useMultilevelDispatchSetup());
    }

    @Override
    protected void assureSdConsistent() {
    }

    @Override
    public int getRowBits() {
        return 8;
    }

    public static class UnionConfiguration
    extends AbstractConfigProducer
    implements AttributesConfig.Producer {
        private final List<DocumentDatabase> docDbs;

        public void getConfig(IndexInfoConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(IlscriptsConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(AttributesConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(RankProfilesConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        private UnionConfiguration(AbstractConfigProducer parent, List<DocumentDatabase> docDbs) {
            super(parent, "union");
            this.docDbs = docDbs;
        }
    }
}

