/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.config.model.ConfigModel;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.content.Content;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;

public class ContainerModel
extends ConfigModel {
    public static final String DOCPROC_RESERVED_NAME = "docproc";
    private ContainerCluster containerCluster;

    public ContainerModel(ConfigModelContext context) {
        super(context);
    }

    public void setCluster(ContainerCluster containerCluster) {
        this.containerCluster = containerCluster;
    }

    public ContainerCluster getCluster() {
        return this.containerCluster;
    }

    @Override
    public void prepare(ConfigModelRepo plugins, DeployState deployState) {
        assert (this.getCluster() != null) : "Null container cluster!";
        this.getCluster().prepare(deployState);
    }

    @Override
    @Deprecated
    public void initialize(ConfigModelRepo configModelRepo) {
        List<AbstractSearchCluster> searchClusters = Content.getSearchClusters(configModelRepo);
        TreeMap<String, AbstractSearchCluster> searchClustersByName = new TreeMap<String, AbstractSearchCluster>();
        for (AbstractSearchCluster c : searchClusters) {
            searchClustersByName.put(c.getClusterName(), c);
        }
        this.getCluster().initialize(searchClustersByName);
    }

    public static Collection<ContainerCluster> containerClusters(ConfigModelRepo models) {
        ArrayList<ContainerCluster> containerClusters = new ArrayList<ContainerCluster>();
        for (ContainerModel model : models.getModels(ContainerModel.class)) {
            containerClusters.add(model.getCluster());
        }
        return containerClusters;
    }
}

