/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.DerivedConfiguration;
import com.yahoo.searchdefinition.derived.Summaries;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.config.search.SummarymapConfig;
import com.yahoo.vespa.config.search.vsm.VsmfieldsConfig;
import com.yahoo.vespa.config.search.vsm.VsmsummaryConfig;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.search.SearchCluster;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class StreamingSearchCluster
extends SearchCluster
implements DocumentdbInfoConfig.Producer,
RankProfilesConfig.Producer,
VsmsummaryConfig.Producer,
VsmfieldsConfig.Producer,
SummarymapConfig.Producer,
SummaryConfig.Producer {
    private final String storageRouteSpec;
    private final AttributesProducer attributesConfig;
    private final String docTypeName;
    private DerivedConfiguration sdConfig = null;

    public StreamingSearchCluster(AbstractConfigProducer parent, String clusterName, int index, String docTypeName, String storageRouteSpec) {
        super(parent, clusterName, index);
        this.attributesConfig = new AttributesProducer(parent, docTypeName);
        this.docTypeName = docTypeName;
        this.storageRouteSpec = storageRouteSpec;
    }

    public final String getDocumentDBConfigId() {
        return this.attributesConfig.getConfigId();
    }

    @Override
    protected AbstractSearchCluster.IndexingMode getIndexingMode() {
        return AbstractSearchCluster.IndexingMode.STREAMING;
    }

    public final String getStorageRouteSpec() {
        return this.storageRouteSpec;
    }

    public String getDocTypeName() {
        return this.docTypeName;
    }

    @Override
    public int getRowBits() {
        return 0;
    }

    @Override
    public void getConfig(DocumentdbInfoConfig.Builder builder) {
        DocumentdbInfoConfig.Documentdb.Builder docDb = new DocumentdbInfoConfig.Documentdb.Builder();
        String searchName = this.sdConfig.getSearch().getName();
        docDb.name(searchName);
        Summaries prod = this.sdConfig.getSummaries();
        this.convertSummaryConfig(prod, null, docDb);
        RankProfilesConfig.Builder rpb = new RankProfilesConfig.Builder();
        this.sdConfig.getRankProfileList().getConfig(rpb);
        this.addRankProfilesConfig(docDb, new RankProfilesConfig(rpb));
        builder.documentdb(docDb);
    }

    @Override
    protected void assureSdConsistent() {
        if (this.sdConfig == null) {
            throw new IllegalStateException("Search cluster '" + this.getClusterName() + "' does not have any search definitions");
        }
    }

    @Override
    protected void deriveAllSearchDefinitions(List<AbstractSearchCluster.SearchDefinitionSpec> local, List<Search> global) {
        if (local.size() == 1) {
            this.deriveSingleSearchDefinition(local.get(0).getSearchDefinition().getSearch(), global);
        } else if (local.size() > 1) {
            throw new IllegalStateException("Logical indexes are not supported: Got " + local.size() + " search definitions, expected 1");
        }
    }

    private void deriveSingleSearchDefinition(Search localSearch, List<Search> globalSearches) {
        if (!localSearch.getName().equals(this.docTypeName)) {
            throw new IllegalStateException("Mismatch between document type name (" + this.docTypeName + ") and name of search definition (" + localSearch.getName() + ")");
        }
        this.sdConfig = new DerivedConfiguration(localSearch, globalSearches, this.deployLogger(), this.getRoot().getDeployState().rankProfileRegistry(), this.getRoot().getDeployState().getQueryProfiles().getRegistry(), this.getRoot().getDeployState().getImportedModels());
    }

    @Override
    public DerivedConfiguration getSdConfig() {
        return this.sdConfig;
    }

    @Override
    protected void exportSdFiles(File toDir) throws IOException {
        if (this.sdConfig != null) {
            this.sdConfig.export(toDir.getCanonicalPath());
        }
    }

    @Override
    public void defaultDocumentsConfig() {
    }

    @Override
    public void getConfig(AttributesConfig.Builder builder) {
        if (this.getSdConfig() != null) {
            this.getSdConfig().getAttributeFields().getConfig(builder);
        }
    }

    public void getConfig(VsmsummaryConfig.Builder builder) {
        if (this.getSdConfig() != null && this.getSdConfig().getVsmSummary() != null) {
            this.getSdConfig().getVsmSummary().getConfig(builder);
        }
    }

    public void getConfig(VsmfieldsConfig.Builder builder) {
        if (this.getSdConfig() != null && this.getSdConfig().getVsmFields() != null) {
            this.getSdConfig().getVsmFields().getConfig(builder);
        }
    }

    public void getConfig(SummarymapConfig.Builder builder) {
        if (this.getSdConfig() != null && this.getSdConfig().getSummaryMap() != null) {
            this.getSdConfig().getSummaryMap().getConfig(builder);
        }
    }

    public void getConfig(SummaryConfig.Builder builder) {
        if (this.getSdConfig() != null && this.getSdConfig().getSummaries() != null) {
            this.getSdConfig().getSummaries().getConfig(builder);
        }
    }

    private class AttributesProducer
    extends AbstractConfigProducer
    implements AttributesConfig.Producer {
        AttributesProducer(AbstractConfigProducer parent, String docType) {
            super(parent, docType);
        }

        public void getConfig(AttributesConfig.Builder builder) {
            if (StreamingSearchCluster.this.getSdConfig() != null) {
                StreamingSearchCluster.this.getSdConfig().getAttributeFields().getConfig(builder, AttributeFields.FieldSet.FAST_ACCESS);
            }
        }
    }
}

