/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class StringSettingsOnNonStringFields
extends Processor {
    public StringSettingsOnNonStringFields(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate) {
        if (!validate) {
            return;
        }
        for (SDField field : this.search.allConcreteFields()) {
            if (!this.doCheck(field)) continue;
            if (field.getMatching().isTypeUserSet()) {
                this.warn(this.search, field, "Matching type " + (Object)((Object)field.getMatching().getType()) + " is only allowed for string fields.");
            }
            if (!field.getRanking().isLiteral()) continue;
            this.warn(this.search, field, "Rank type literal only applies to string fields");
        }
    }

    private boolean doCheck(SDField field) {
        if (field.getDataType() instanceof NumericDataType) {
            return true;
        }
        return field.getDataType() instanceof CollectionDataType && ((CollectionDataType)field.getDataType()).getNestedType() instanceof NumericDataType;
    }
}

