/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class RankingExpressionTypeValidator
extends Processor {
    private final QueryProfileRegistry queryProfiles;

    public RankingExpressionTypeValidator(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
        this.queryProfiles = queryProfiles.getRegistry();
    }

    @Override
    public void process(boolean validate) {
        if (!validate) {
            return;
        }
        for (RankProfile profile : this.rankProfileRegistry.rankProfilesOf(this.search)) {
            try {
                this.validate(profile);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("In " + this.search + ", " + profile, e);
            }
        }
    }

    private void validate(RankProfile profile) {
        profile.parseExpressions();
        TypeContext<Reference> context = profile.typeContext(this.queryProfiles);
        profile.getSummaryFeatures().forEach(f -> this.ensureValid((ExpressionNode)f, "summary feature " + f, context));
        this.ensureValidDouble(profile.getFirstPhaseRanking(), "first-phase expression", context);
        this.ensureValidDouble(profile.getSecondPhaseRanking(), "second-phase expression", context);
    }

    private TensorType ensureValid(RankingExpression expression, String expressionDescription, TypeContext context) {
        if (expression == null) {
            return null;
        }
        return this.ensureValid(expression.getRoot(), expressionDescription, context);
    }

    private TensorType ensureValid(ExpressionNode expression, String expressionDescription, TypeContext context) {
        TensorType type;
        try {
            type = expression.type(context);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The " + expressionDescription + " is invalid", e);
        }
        if (type == null) {
            throw new IllegalStateException("Could not determine the type produced by " + expressionDescription);
        }
        return type;
    }

    private void ensureValidDouble(RankingExpression expression, String expressionDescription, TypeContext context) {
        if (expression == null) {
            return;
        }
        TensorType type = this.ensureValid(expression, expressionDescription, context);
        if (!type.equals((Object)TensorType.empty)) {
            throw new IllegalArgumentException("The " + expressionDescription + " must produce a double (a tensor with no dimensions), but produces " + type);
        }
    }
}

