/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class MatchPhaseSettingsValidator
extends Processor {
    public MatchPhaseSettingsValidator(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate) {
        if (!validate) {
            return;
        }
        for (RankProfile rankProfile : this.rankProfileRegistry.rankProfilesOf(this.search)) {
            RankProfile.MatchPhaseSettings settings = rankProfile.getMatchPhaseSettings();
            if (settings == null) continue;
            this.validateMatchPhaseSettings(rankProfile, settings);
        }
    }

    private void validateMatchPhaseSettings(RankProfile rankProfile, RankProfile.MatchPhaseSettings settings) {
        String attributeName = settings.getAttribute();
        new AttributeValidator(this.search.getName(), rankProfile.getName(), this.search.getAttribute(attributeName), attributeName).validate();
    }

    public static class AttributeValidator {
        private final String searchName;
        private final String rankProfileName;
        protected final Attribute attribute;
        private final String attributeName;

        public AttributeValidator(String searchName, String rankProfileName, Attribute attribute, String attributeName) {
            this.searchName = searchName;
            this.rankProfileName = rankProfileName;
            this.attribute = attribute;
            this.attributeName = attributeName;
        }

        public void validate() {
            this.validateThatAttributeExists();
            this.validateThatAttributeIsSingleNumeric();
            this.validateThatAttributeIsFastSearch();
        }

        protected void validateThatAttributeExists() {
            if (this.attribute == null) {
                this.failValidation("does not exists");
            }
        }

        protected void validateThatAttributeIsSingleNumeric() {
            if (!this.attribute.getCollectionType().equals((Object)Attribute.CollectionType.SINGLE) || this.attribute.getType().equals((Object)Attribute.Type.STRING) || this.attribute.getType().equals((Object)Attribute.Type.PREDICATE)) {
                this.failValidation("must be single value numeric, but it is '" + this.attribute.getDataType().getName() + "'");
            }
        }

        protected void validateThatAttributeIsFastSearch() {
            if (!this.attribute.isFastSearch()) {
                this.failValidation("must be fast-search, but it is not");
            }
        }

        protected void failValidation(String what) {
            throw new IllegalArgumentException(this.createMessagePrefix() + what);
        }

        public String getValidationType() {
            return "match-phase";
        }

        private String createMessagePrefix() {
            return "In search definition '" + this.searchName + "', rank-profile '" + this.rankProfileName + "': " + this.getValidationType() + " attribute '" + this.attributeName + "' ";
        }
    }
}

