/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.PositionDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ComplexAttributeFieldUtils;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.logging.Level;

public class ImplicitSummaries
extends Processor {
    public ImplicitSummaries(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate) {
        DocumentSummary defaultSummary = this.search.getSummary("default");
        if (defaultSummary == null) {
            defaultSummary = new DocumentSummary("default");
            this.search.addSummary(defaultSummary);
        }
        for (SDField field : this.search.allConcreteFields()) {
            this.collectSummaries(field, this.search, validate);
        }
        for (DocumentSummary documentSummary : this.search.getSummaries().values()) {
            documentSummary.purgeImplicits();
        }
    }

    private void addSummaryFieldSources(SummaryField summaryField, SDField sdField) {
        sdField.addSummaryFieldSources(summaryField);
    }

    private void collectSummaries(SDField field, Search search, boolean validate) {
        SummaryField addedSummaryField = null;
        String fieldName = field.getName();
        SummaryField fieldSummaryField = field.getSummaryField(fieldName);
        if (fieldSummaryField == null && field.doesSummarying()) {
            fieldSummaryField = new SummaryField(fieldName, field.getDataType());
            fieldSummaryField.setImplicit(true);
            this.addSummaryFieldSources(fieldSummaryField, field);
            fieldSummaryField.addDestination("default");
            field.addSummaryField(fieldSummaryField);
            addedSummaryField = fieldSummaryField;
        }
        if (fieldSummaryField != null) {
            for (String dest : fieldSummaryField.getDestinations()) {
                DocumentSummary summary = search.getSummary(dest);
                if (summary == null) continue;
                summary.add(fieldSummaryField);
            }
        }
        for (Attribute attribute : field.getAttributes().values()) {
            if (!attribute.getName().equals(fieldName)) continue;
            if (addedSummaryField != null) {
                addedSummaryField.setTransform(SummaryTransform.ATTRIBUTE);
            }
            if (!attribute.isPrefetch()) continue;
            this.addPrefetchAttribute(attribute, field, search);
        }
        if (addedSummaryField != null && ComplexAttributeFieldUtils.isComplexFieldWithOnlyStructFieldAttributes(field)) {
            addedSummaryField.setTransform(SummaryTransform.ATTRIBUTECOMBINER);
        }
        if (field.doesSummarying()) {
            for (Attribute attribute : field.getAttributes().values()) {
                if (!attribute.isPosition()) continue;
                DocumentSummary attributePrefetchSummary = this.getOrCreateAttributePrefetchSummary(search);
                attributePrefetchSummary.add(field.getSummaryField(PositionDataType.getDistanceSummaryFieldName((String)fieldName)));
                attributePrefetchSummary.add(field.getSummaryField(PositionDataType.getPositionSummaryFieldName((String)fieldName)));
            }
        }
        for (SummaryField summaryField : field.getSummaryFields()) {
            Attribute attribute = field.getAttributes().get(fieldName);
            if (attribute != null && summaryField.getTransform() == SummaryTransform.NONE) {
                summaryField.setTransform(SummaryTransform.ATTRIBUTE);
            }
            if (!this.isValid(summaryField, search, validate)) continue;
            this.addToDestinations(summaryField, search);
        }
    }

    private DocumentSummary getOrCreateAttributePrefetchSummary(Search search) {
        DocumentSummary summary = search.getSummary("attributeprefetch");
        if (summary == null) {
            summary = new DocumentSummary("attributeprefetch");
            search.addSummary(summary);
        }
        return summary;
    }

    private void addPrefetchAttribute(Attribute attribute, SDField field, Search search) {
        if (attribute.getPrefetchValue() == null) {
            SummaryField fieldSummaryField = field.getSummaryField(attribute.getName());
            if (fieldSummaryField != null && fieldSummaryField.getTransform().isDynamic()) {
                return;
            }
            SummaryField explicitSummaryField = search.getExplicitSummaryField(attribute.getName());
            if (explicitSummaryField != null && explicitSummaryField.getTransform().isDynamic()) {
                return;
            }
        }
        DocumentSummary summary = this.getOrCreateAttributePrefetchSummary(search);
        SummaryField attributeSummaryField = new SummaryField(attribute.getName(), attribute.getDataType());
        attributeSummaryField.addSource(attribute.getName());
        attributeSummaryField.addDestination("attributeprefetch");
        attributeSummaryField.setTransform(SummaryTransform.ATTRIBUTE);
        summary.add(attributeSummaryField);
    }

    private boolean isValid(SummaryField summaryField, Search search, boolean validate) {
        Attribute attribute;
        if (summaryField.getTransform() == SummaryTransform.DISTANCE || summaryField.getTransform() == SummaryTransform.POSITIONS) {
            int sourceCount = summaryField.getSourceCount();
            if (validate && sourceCount != 1) {
                throw this.newProcessException(search.getName(), summaryField.getName(), "Expected 1 source field, got " + sourceCount + ".");
            }
            String sourceName = summaryField.getSingleSource();
            if (validate && search.getAttribute(sourceName) == null) {
                throw this.newProcessException(search.getName(), summaryField.getName(), "Summary source attribute '" + sourceName + "' not found.");
            }
            return true;
        }
        String fieldName = summaryField.getSourceField();
        SDField sourceField = search.getConcreteField(fieldName);
        if (validate && sourceField == null) {
            throw this.newProcessException(search, summaryField, "Source field '" + fieldName + "' does not exist.");
        }
        if (!(sourceField.doesSummarying() || summaryField.getTransform().equals((Object)SummaryTransform.ATTRIBUTE) || summaryField.getTransform().equals((Object)SummaryTransform.GEOPOS))) {
            this.deployLogger.log(Level.WARNING, "Ignoring " + summaryField + ": " + sourceField + " is not creating a summary value in its indexing statement");
            return false;
        }
        if (summaryField.getTransform().isDynamic() && summaryField.getName().equals(sourceField.getName()) && sourceField.doesAttributing() && (attribute = sourceField.getAttributes().get(sourceField.getName())) != null) {
            String destinations = "document summary 'default'";
            if (summaryField.getDestinations().size() > 0) {
                destinations = "document summaries " + summaryField.getDestinations();
            }
            this.deployLogger.log(Level.WARNING, "Will fetch the disk summary value of " + sourceField + " in " + destinations + " since this summary field uses a dynamic summary value (snippet/bolding): Dynamic summaries and bolding is not supported with summary values fetched from in-memory attributes yet. If you want to see partial updates to this attribute, remove any bolding and dynamic snippeting from this field");
        }
        return true;
    }

    private void addToDestinations(SummaryField summaryField, Search search) {
        if (summaryField.getDestinations().size() == 0) {
            this.addToDestination("default", summaryField, search);
        } else {
            for (String destinationName : summaryField.getDestinations()) {
                this.addToDestination(destinationName, summaryField, search);
            }
        }
    }

    private void addToDestination(String destinationName, SummaryField summaryField, Search search) {
        DocumentSummary destination = search.getSummary(destinationName);
        if (destination == null) {
            destination = new DocumentSummary(destinationName);
            search.addSummary(destination);
            destination.add(summaryField);
        } else {
            SummaryField existingField = destination.getSummaryField(summaryField.getName());
            SummaryField merged = summaryField.mergeWith(existingField);
            destination.add(merged);
        }
    }
}

