/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class AttributesImplicitWord
extends Processor {
    public AttributesImplicitWord(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate) {
        for (SDField field : this.search.allConcreteFields()) {
            if (!this.fieldImplicitlyWordMatch(field)) continue;
            field.getMatching().setType(Matching.Type.WORD);
        }
    }

    private boolean fieldImplicitlyWordMatch(SDField field) {
        PrimitiveDataType dt = field.getDataType().getPrimitiveType();
        if (dt != null && dt instanceof NumericDataType) {
            return false;
        }
        return field.getIndexToCount() == 0 && !field.getAttributes().isEmpty() && field.getIndices().isEmpty() && !field.getMatching().isTypeUserSet();
    }
}

