/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.FileReference;
import com.yahoo.searchdefinition.RankingConstant;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.utils.FileSender;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RankingConstants {
    private final Map<String, RankingConstant> constants = new HashMap<String, RankingConstant>();

    public void add(RankingConstant constant) {
        constant.validate();
        String name = constant.getName();
        if (this.constants.containsKey(name)) {
            throw new IllegalArgumentException("Ranking constant '" + name + "' defined twice");
        }
        this.constants.put(name, constant);
    }

    public RankingConstant get(String name) {
        return this.constants.get(name);
    }

    public Map<String, RankingConstant> asMap() {
        return Collections.unmodifiableMap(this.constants);
    }

    public void sendTo(Collection<? extends AbstractService> services) {
        for (RankingConstant constant : this.constants.values()) {
            FileReference reference = constant.getPathType() == RankingConstant.PathType.FILE ? FileSender.sendFileToServices(constant.getFileName(), services) : FileSender.sendUriToServices(constant.getUri(), services);
            constant.setFileReference(reference.value());
        }
    }
}

