/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.cluster;

import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GlobalDistributionBuilder {
    private final Map<String, NewDocumentType> documentDefinitions;

    public GlobalDistributionBuilder(Map<String, NewDocumentType> documentDefinitions) {
        this.documentDefinitions = Collections.unmodifiableMap(documentDefinitions);
    }

    public Set<NewDocumentType> build(ModelElement documentsElement) {
        return documentsElement.subElements("document").stream().filter(GlobalDistributionBuilder::isGloballyDistributed).map(GlobalDistributionBuilder::getDocumentName).map(this::getDocumentType).collect(Collectors.toSet());
    }

    private static boolean isGloballyDistributed(ModelElement e) {
        return e.getBooleanAttribute("global", false);
    }

    private static String getDocumentName(ModelElement e) {
        return e.getStringAttribute("type");
    }

    private NewDocumentType getDocumentType(String name) {
        return this.documentDefinitions.get(name);
    }
}

