/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.admin.Configserver;
import com.yahoo.vespa.model.admin.LogForwarder;
import com.yahoo.vespa.model.admin.ModelConfigProvider;
import com.yahoo.vespa.model.admin.monitoring.DefaultMonitoring;
import com.yahoo.vespa.model.admin.monitoring.MetricsConsumer;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.admin.monitoring.builder.Metrics;
import com.yahoo.vespa.model.admin.monitoring.builder.PredefinedMetricSets;
import com.yahoo.vespa.model.admin.monitoring.builder.xml.MetricsBuilder;
import com.yahoo.vespa.model.builder.xml.dom.DomMetricBuilderHelper;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProducer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class DomAdminBuilderBase
extends VespaDomBuilder.DomConfigProducerBuilder<Admin> {
    private static final int DEFAULT_INTERVAL = 1;
    private static final String DEFAULT_CLUSTER_NAME = "vespa";
    private final ConfigModelContext.ApplicationType applicationType;
    protected final List<ConfigServerSpec> configServerSpecs;
    private final FileRegistry fileRegistry;
    protected final boolean multitenant;

    DomAdminBuilderBase(ConfigModelContext.ApplicationType applicationType, FileRegistry fileRegistry, boolean multitenant, List<ConfigServerSpec> configServerSpecs) {
        this.applicationType = applicationType;
        this.fileRegistry = fileRegistry;
        this.multitenant = multitenant;
        this.configServerSpecs = configServerSpecs;
    }

    List<Configserver> getConfigServersFromSpec(AbstractConfigProducer parent) {
        ArrayList<Configserver> configservers = new ArrayList<Configserver>();
        for (ConfigServerSpec spec : this.configServerSpecs) {
            HostSystem hostSystem = parent.getHostSystem();
            HostResource host = new HostResource(Host.createConfigServerHost(hostSystem, spec.getHostName()));
            hostSystem.addBoundHost(host);
            Configserver configserver = new Configserver(parent, spec.getHostName(), spec.getConfigServerPort());
            configserver.setHostResource(host);
            configserver.setBasePort(configserver.getWantedPort());
            configserver.initService();
            configservers.add(configserver);
        }
        return configservers;
    }

    @Override
    protected Admin doBuild(AbstractConfigProducer parent, Element adminElement) {
        Monitoring monitoring = this.getMonitoring(this.getChildWithFallback(adminElement, "monitoring", "yamas"));
        Metrics metrics = new MetricsBuilder(this.applicationType, PredefinedMetricSets.predefinedMetricSets).buildMetrics(XML.getChild((Element)adminElement, (String)"metrics"));
        Map<String, MetricsConsumer> legacyMetricsConsumers = DomMetricBuilderHelper.buildMetricsConsumers(XML.getChild((Element)adminElement, (String)"metric-consumers"));
        FileDistributionConfigProducer fileDistributionConfigProducer = this.getFileDistributionConfigProducer(parent);
        Admin admin = new Admin(parent, monitoring, metrics, legacyMetricsConsumers, this.multitenant, fileDistributionConfigProducer);
        admin.setApplicationType(this.applicationType);
        this.doBuildAdmin(admin, adminElement);
        new ModelConfigProvider(admin);
        return admin;
    }

    private FileDistributionConfigProducer getFileDistributionConfigProducer(AbstractConfigProducer parent) {
        return new FileDistributionConfigProducer(parent, this.fileRegistry, this.configServerSpecs);
    }

    private Element getChildWithFallback(Element parent, String childName, String alternativeChildName) {
        Element child = XML.getChild((Element)parent, (String)childName);
        if (child != null) {
            return child;
        }
        return XML.getChild((Element)parent, (String)alternativeChildName);
    }

    protected abstract void doBuildAdmin(Admin var1, Element var2);

    private Monitoring getMonitoring(Element monitoringElement) {
        if (monitoringElement == null) {
            return new DefaultMonitoring(DEFAULT_CLUSTER_NAME, 1);
        }
        Integer minutes = this.getMonitoringInterval(monitoringElement);
        if (minutes == null) {
            minutes = 1;
        }
        return new DefaultMonitoring(monitoringElement.getAttribute("systemname"), minutes);
    }

    private Integer getMonitoringInterval(Element monitoringE) {
        Integer minutes = null;
        String seconds = monitoringE.getAttribute("interval").trim();
        if (!seconds.isEmpty() && (minutes = Integer.valueOf(Integer.parseInt(seconds) / 60)) != 1 && minutes != 5) {
            throw new IllegalArgumentException("The only allowed values for 'interval' attribute in '" + monitoringE.getTagName() + "' element is 60 or 300.");
        }
        return minutes;
    }

    void addLogForwarders(ModelElement logForwardingElement, Admin admin) {
        if (logForwardingElement == null) {
            return;
        }
        for (ModelElement e : logForwardingElement.getChildren("splunk")) {
            LogForwarder.Config cfg = LogForwarder.cfg().withSplunkHome(e.getStringAttribute("splunk-home")).withDeploymentServer(e.getStringAttribute("deployment-server")).withClientName(e.getStringAttribute("client-name"));
            admin.setLogForwarderConfig(cfg);
        }
    }
}

