/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.expressiontransforms;

import com.yahoo.path.Path;
import com.yahoo.searchdefinition.expressiontransforms.ConvertedModel;
import com.yahoo.searchdefinition.expressiontransforms.RankProfileTransformContext;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import com.yahoo.searchlib.rankingexpression.transform.TransformContext;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;

public class XgboostFeatureConverter
extends ExpressionTransformer<RankProfileTransformContext> {
    private final Map<Path, ConvertedModel> convertedXGBoostModels = new HashMap<Path, ConvertedModel>();

    public ExpressionNode transform(ExpressionNode node, RankProfileTransformContext context) {
        if (node instanceof ReferenceNode) {
            return this.transformFeature((ReferenceNode)node, context);
        }
        if (node instanceof CompositeNode) {
            return super.transformChildren((CompositeNode)node, (TransformContext)context);
        }
        return node;
    }

    private ExpressionNode transformFeature(ReferenceNode feature, RankProfileTransformContext context) {
        if (!feature.getName().equals("xgboost")) {
            return feature;
        }
        try {
            Path modelPath = Path.fromString((String)ConvertedModel.FeatureArguments.asString((ExpressionNode)feature.getArguments().expressions().get(0)));
            ConvertedModel convertedModel = this.convertedXGBoostModels.computeIfAbsent(modelPath, __ -> new ConvertedModel(modelPath, context));
            return convertedModel.expression(this.asFeatureArguments(feature.getArguments()));
        }
        catch (UncheckedIOException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not use XGBoost model from " + feature, e);
        }
    }

    private ConvertedModel.FeatureArguments asFeatureArguments(Arguments arguments) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("An xgboost node must take a single argument pointing to the xgboost model directory under [application]/models");
        }
        return new ConvertedModel.FeatureArguments(arguments);
    }
}

